/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.DefaultThreadFactory;
import com.weibo.api.motan.core.StandardThreadExecutor;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.transport.AbstractClient;
import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.transport.SharedObjectFactory;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MathUtil;
import java.util.ArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractSharedPoolClient
extends AbstractClient {
    private static final ThreadPoolExecutor executor = new StandardThreadExecutor(1, 300, 20000, new DefaultThreadFactory("AbstractPoolClient-initPool-", true));
    private final AtomicInteger idx = new AtomicInteger();
    protected SharedObjectFactory factory;
    protected ArrayList<Channel> channels;
    protected int connections;

    public AbstractSharedPoolClient(URL url) {
        super(url);
        this.connections = url.getIntParameter(URLParamType.minClientConnection.getName(), URLParamType.minClientConnection.getIntValue());
        if (this.connections <= 0) {
            this.connections = URLParamType.minClientConnection.getIntValue();
        }
    }

    protected void initPool() {
        this.factory = this.createChannelFactory();
        this.channels = new ArrayList(this.connections);
        for (int i = 0; i < this.connections; ++i) {
            this.channels.add((Channel)this.factory.makeObject());
        }
        this.initConnections(this.url.getBooleanParameter(URLParamType.asyncInitConnection.getName(), URLParamType.asyncInitConnection.getBooleanValue()));
    }

    protected abstract SharedObjectFactory createChannelFactory();

    protected void initConnections(boolean async) {
        if (async) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractSharedPoolClient.this.createConnections();
                }
            });
        } else {
            this.createConnections();
        }
    }

    private void createConnections() {
        for (Channel channel : this.channels) {
            try {
                channel.open();
            }
            catch (Exception e) {
                LoggerUtil.error("NettyClient init pool create connect Error: url=" + this.url.getUri(), e);
            }
        }
    }

    protected Channel getChannel() throws MotanServiceException {
        int index;
        for (int i = index = MathUtil.getPositive(this.idx.getAndIncrement()); i < this.connections + index; ++i) {
            Channel channel = this.channels.get(i % this.connections);
            if (channel.isAvailable()) {
                return channel;
            }
            this.factory.rebuildObject(channel);
        }
        String errorMsg = this.getClass().getSimpleName() + " getChannel Error: url=" + this.url.getUri();
        LoggerUtil.error(errorMsg);
        throw new MotanServiceException(errorMsg);
    }
}

