/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.serialize;

import com.weibo.api.motan.codec.Serialization;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.protocol.v2motan.GrowableByteBuffer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

@SpiMeta(name="simple")
public class SimpleSerialization
implements Serialization {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] serialize(Object obj) throws IOException {
        GrowableByteBuffer buffer = new GrowableByteBuffer(4096);
        if (obj != null) {
            if (obj instanceof String) {
                buffer.put((byte)1);
                byte[] b = ((String)obj).getBytes("UTF-8");
                buffer.putInt(b.length);
                buffer.put(b);
            } else if (obj instanceof Map) {
                buffer.put((byte)2);
                int size = 0;
                buffer.position(5);
                for (Map.Entry entry : ((Map)obj).entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null || !(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
                    size += this.putString(buffer, (String)entry.getKey());
                    size += this.putString(buffer, (String)entry.getValue());
                }
                buffer.position(1);
                buffer.putInt(size);
                buffer.position(5 + size);
            } else {
                if (!(obj instanceof byte[])) throw new MotanServiceException("SimpleSerialization not support type:" + obj.getClass());
                buffer.put((byte)3);
                byte[] b = (byte[])obj;
                buffer.putInt(b.length);
                buffer.put(b);
            }
        } else {
            buffer.put((byte)0);
        }
        buffer.flip();
        byte[] result = new byte[buffer.remaining()];
        buffer.get(result);
        return result;
    }

    @Override
    public <T> T deserialize(byte[] bytes, Class<T> clz) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        byte type = buffer.get();
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                if (clz == String.class || clz == Object.class) {
                    String str = this.getString(buffer);
                    return (T)str;
                }
                throw new MotanServiceException("SimpleSerialization not support type:" + clz);
            }
            case 2: {
                if (clz == Map.class || clz == Object.class) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    int size = buffer.getInt();
                    if (size > 0) {
                        if (size > buffer.remaining()) {
                            throw new MotanServiceException("SimpleSerialization deserialize fail! buffer not enough!need size:" + size);
                        }
                        buffer.limit(buffer.position() + size);
                        String key = this.getString(buffer);
                        while (key != null) {
                            String value = this.getString(buffer);
                            if (value == null) {
                                throw new MotanServiceException("SimpleSerialization deserialize map fail! key and value not match. key:" + key);
                            }
                            map.put(key, value);
                            key = this.getString(buffer);
                        }
                    }
                    return (T)map;
                }
                throw new MotanServiceException("SimpleSerialization not support type:" + clz);
            }
            case 3: {
                if (clz != byte[].class && clz != Object.class) break;
                return (T)this.getBytes(buffer);
            }
        }
        return null;
    }

    @Override
    public byte[] serializeMulti(Object[] data) throws IOException {
        if (data.length == 1) {
            return this.serialize(data[0]);
        }
        throw new MotanServiceException("SimpleSerialization not support serialize multi Object");
    }

    @Override
    public Object[] deserializeMulti(byte[] data, Class<?>[] classes) throws IOException {
        if (classes.length == 1) {
            return new Object[]{this.deserialize(data, classes[0])};
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("[");
        for (Class<?> c : classes) {
            sb.append(c.getName()).append(",");
        }
        if (sb.length() > 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]");
        throw new MotanServiceException("SimpleSerialization not support deserialize multi Object of " + classes);
    }

    @Override
    public int getSerializationNumber() {
        return 6;
    }

    private int putString(GrowableByteBuffer buffer, String str) throws UnsupportedEncodingException {
        byte[] b = str.getBytes("UTF-8");
        buffer.putInt(b.length);
        buffer.put(b);
        return 4 + b.length;
    }

    private String getString(ByteBuffer buffer) throws UnsupportedEncodingException {
        byte[] bytes = this.getBytes(buffer);
        if (bytes == null) {
            return null;
        }
        return new String(bytes, "UTF-8");
    }

    private byte[] getBytes(ByteBuffer buffer) throws UnsupportedEncodingException {
        if (buffer.remaining() >= 4) {
            int size = buffer.getInt();
            if (size > buffer.remaining()) {
                throw new MotanServiceException("SimpleSerialization deserialize fail! buffer not enough!need size:" + size);
            }
            if (size == 0) {
                return new byte[0];
            }
            byte[] b = new byte[size];
            buffer.get(b);
            return b;
        }
        return null;
    }
}

