/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.common.application;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.wavefront.sdk.common.annotation.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ApplicationTags {
    private final String application;
    @Nullable
    private final String cluster;
    private final String service;
    @Nullable
    private final String shard;
    private final Map<String, String> customTags;

    private ApplicationTags(Builder builder) {
        this.application = builder.application;
        this.cluster = builder.cluster;
        this.service = builder.service;
        this.shard = builder.shard;
        this.customTags = builder.customTags;
    }

    public String getApplication() {
        return this.application;
    }

    @Nullable
    public String getCluster() {
        return this.cluster;
    }

    public String getService() {
        return this.service;
    }

    @Nullable
    public String getShard() {
        return this.shard;
    }

    @Nullable
    public Map<String, String> getCustomTags() {
        return this.customTags;
    }

    public Map<String, String> toPointTags() {
        return Collections.unmodifiableMap(new HashMap<String, String>(){
            {
                this.put("application", ApplicationTags.this.application);
                this.put("cluster", ApplicationTags.this.cluster == null ? "none" : ApplicationTags.this.cluster);
                this.put("service", ApplicationTags.this.service);
                this.put("shard", ApplicationTags.this.shard == null ? "none" : ApplicationTags.this.shard);
                if (ApplicationTags.this.customTags != null) {
                    this.putAll(ApplicationTags.this.customTags);
                }
            }
        });
    }

    public static class Builder {
        private final String application;
        private final String service;
        @Nullable
        private String cluster;
        @Nullable
        private String shard;
        private Map<String, String> customTags = new HashMap<String, String>();

        public Builder(String application, String service) {
            this.application = application;
            this.service = service;
        }

        public Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder shard(String shard) {
            this.shard = shard;
            return this;
        }

        public Builder customTags(Map<String, String> customTags) {
            this.customTags.putAll(customTags);
            return this;
        }

        public Builder tagsFromEnv(String regex) {
            Pattern pattern = Pattern.compile(regex, 2);
            Map<String, String> env = this.getenv();
            env.forEach((var, value) -> {
                Matcher matcher = pattern.matcher((CharSequence)var);
                if (matcher.matches() && !Strings.isNullOrEmpty((String)value)) {
                    this.customTags.put((String)var, (String)value);
                }
            });
            return this;
        }

        @VisibleForTesting
        Map<String, String> getenv() {
            return System.getenv();
        }

        public Builder tagFromEnv(String varName, String tagName) {
            String value = this.getenv().get(varName);
            if (!Strings.isNullOrEmpty((String)value)) {
                this.customTags.put(tagName, value);
            }
            return this;
        }

        public ApplicationTags build() {
            return new ApplicationTags(this);
        }
    }
}

