/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.format;

import com.vladsch.flexmark.util.format.options.DiscretionaryText;
import com.vladsch.flexmark.util.mappers.CharWidthProvider;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.DataKey;
import com.vladsch.flexmark.util.options.MutableDataHolder;
import com.vladsch.flexmark.util.options.MutableDataSetter;

public class TableFormatOptions
implements MutableDataSetter {
    public static final DataKey<Boolean> LEAD_TRAIL_PIPES = new DataKey<Boolean>("LEAD_TRAIL_PIPES", true);
    public static final DataKey<Boolean> SPACE_AROUND_PIPES = new DataKey<Boolean>("SPACE_AROUND_PIPES", true);
    public static final DataKey<Boolean> ADJUST_COLUMN_WIDTH = new DataKey<Boolean>("ADJUST_COLUMN_WIDTH", true);
    public static final DataKey<Boolean> APPLY_COLUMN_ALIGNMENT = new DataKey<Boolean>("APPLY_COLUMN_ALIGNMENT", true);
    public static final DataKey<Boolean> FILL_MISSING_COLUMNS = new DataKey<Boolean>("FILL_MISSING_COLUMNS", false);
    public static final DataKey<Boolean> REMOVE_CAPTION = new DataKey<Boolean>("REMOVE_CAPTION", false);
    public static final DataKey<DiscretionaryText> LEFT_ALIGN_MARKER = new DataKey<DiscretionaryText>("LEFT_ALIGN_MARKER", DiscretionaryText.AS_IS);
    public static final DataKey<Integer> MIN_SEPARATOR_COLUMN_WIDTH = new DataKey<Integer>("MIN_SEPARATOR_COLUMN_WIDTH", 3);
    public static final DataKey<Integer> MIN_SEPARATOR_DASHES = new DataKey<Integer>("MIN_SEPARATOR_DASHES", 1);
    public static final DataKey<CharWidthProvider> CHAR_WIDTH_PROVIDER = new DataKey<CharWidthProvider>("CHAR_WIDTH_PROVIDER", CharWidthProvider.NULL);
    public final boolean leadTrailPipes;
    public final boolean spaceAroundPipes;
    public final boolean adjustColumnWidth;
    public final boolean applyColumnAlignment;
    public final boolean fillMissingColumns;
    public final boolean removeCaption;
    public final DiscretionaryText leftAlignMarker;
    public final int minSeparatorColumnWidth;
    public final int minSeparatorDashes;
    public final CharWidthProvider charWidthProvider;
    public final int spaceWidth;
    public final int spacePad;
    public final int pipeWidth;
    public final int colonWidth;
    public final int dashWidth;

    public TableFormatOptions() {
        this(null);
    }

    public TableFormatOptions(DataHolder options) {
        this.leadTrailPipes = LEAD_TRAIL_PIPES.getFrom(options);
        this.spaceAroundPipes = SPACE_AROUND_PIPES.getFrom(options);
        this.adjustColumnWidth = ADJUST_COLUMN_WIDTH.getFrom(options);
        this.applyColumnAlignment = APPLY_COLUMN_ALIGNMENT.getFrom(options);
        this.fillMissingColumns = FILL_MISSING_COLUMNS.getFrom(options);
        this.leftAlignMarker = LEFT_ALIGN_MARKER.getFrom(options);
        this.removeCaption = REMOVE_CAPTION.getFrom(options);
        this.minSeparatorColumnWidth = MIN_SEPARATOR_COLUMN_WIDTH.getFrom(options);
        this.minSeparatorDashes = MIN_SEPARATOR_DASHES.getFrom(options);
        this.charWidthProvider = CHAR_WIDTH_PROVIDER.getFrom(options);
        this.spaceWidth = this.charWidthProvider.spaceWidth();
        this.spacePad = this.spaceAroundPipes ? 2 * this.spaceWidth : 0;
        this.pipeWidth = this.charWidthProvider.charWidth('|');
        this.colonWidth = this.charWidthProvider.charWidth(':');
        this.dashWidth = this.charWidthProvider.charWidth('-');
    }

    @Override
    public MutableDataHolder setIn(MutableDataHolder dataHolder) {
        dataHolder.set(LEAD_TRAIL_PIPES, this.leadTrailPipes);
        dataHolder.set(SPACE_AROUND_PIPES, this.spaceAroundPipes);
        dataHolder.set(ADJUST_COLUMN_WIDTH, this.adjustColumnWidth);
        dataHolder.set(APPLY_COLUMN_ALIGNMENT, this.applyColumnAlignment);
        dataHolder.set(FILL_MISSING_COLUMNS, this.fillMissingColumns);
        dataHolder.set(LEFT_ALIGN_MARKER, this.leftAlignMarker);
        dataHolder.set(REMOVE_CAPTION, this.removeCaption);
        dataHolder.set(MIN_SEPARATOR_COLUMN_WIDTH, this.minSeparatorColumnWidth);
        dataHolder.set(MIN_SEPARATOR_DASHES, this.minSeparatorDashes);
        dataHolder.set(CHAR_WIDTH_PROVIDER, this.charWidthProvider);
        return dataHolder;
    }
}

