/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast;

import com.vladsch.flexmark.ast.BlankLine;
import com.vladsch.flexmark.ast.BlankLineContainer;
import com.vladsch.flexmark.ast.DescendantNodeIterable;
import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.NodeIterable;
import com.vladsch.flexmark.ast.NodeIterator;
import com.vladsch.flexmark.util.Utils;
import com.vladsch.flexmark.util.collection.iteration.ReversiblePeekingIterable;
import com.vladsch.flexmark.util.collection.iteration.ReversiblePeekingIterator;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.SubSequence;

public abstract class Node {
    public static final BasedSequence[] EMPTY_SEGMENTS = BasedSequence.EMPTY_ARRAY;
    public static final String SPLICE = " \u2026 ";
    private Node parent = null;
    private Node firstChild = null;
    private Node lastChild = null;
    private Node prev = null;
    private Node next = null;
    private BasedSequence chars = BasedSequence.NULL;

    public Node() {
    }

    public Node(BasedSequence chars) {
        this.chars = chars;
    }

    public Node getAncestorOfType(Class ... classes) {
        for (Node parent = this.getParent(); parent != null; parent = parent.getParent()) {
            for (Class nodeType : classes) {
                if (!nodeType.isInstance(parent)) continue;
                return parent;
            }
        }
        return null;
    }

    public Node getOldestAncestorOfTypeAfter(Class ancestor, Class after) {
        Node oldestAncestor = null;
        for (Node parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (ancestor.isInstance(parent)) {
                oldestAncestor = parent;
                continue;
            }
            if (after.isInstance(parent)) break;
        }
        return oldestAncestor;
    }

    public Node getChildOfType(Class ... classes) {
        for (Node child = this.getFirstChild(); child != null; child = child.getNext()) {
            for (Class nodeType : classes) {
                if (!nodeType.isInstance(this.parent)) continue;
                return child;
            }
        }
        return null;
    }

    public static int getNodeOfTypeIndex(Node node, Class ... classes) {
        int i = 0;
        for (Class nodeType : classes) {
            if (nodeType.isInstance(node)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isOrDescendantOfType(Class ... classes) {
        for (Node node = this; node != null; node = node.getParent()) {
            if (node.getNodeOfTypeIndex(classes) == -1) continue;
            return true;
        }
        return false;
    }

    public int getNodeOfTypeIndex(Class ... classes) {
        return Node.getNodeOfTypeIndex(this, classes);
    }

    public Node getLastBlankLineChild() {
        return null;
    }

    public ReversiblePeekingIterable<Node> getChildren() {
        if (this.firstChild == null) {
            return NodeIterable.EMPTY;
        }
        return new NodeIterable(this.firstChild, this.lastChild, false);
    }

    public ReversiblePeekingIterable<Node> getReversedChildren() {
        if (this.firstChild == null) {
            return NodeIterable.EMPTY;
        }
        return new NodeIterable(this.firstChild, this.lastChild, true);
    }

    public ReversiblePeekingIterable<Node> getDescendants() {
        if (this.firstChild == null) {
            return NodeIterable.EMPTY;
        }
        return new DescendantNodeIterable(this.getChildren());
    }

    public ReversiblePeekingIterable<Node> getReversedDescendants() {
        if (this.firstChild == null) {
            return NodeIterable.EMPTY;
        }
        return new DescendantNodeIterable(this.getReversedChildren());
    }

    public ReversiblePeekingIterator<Node> getChildIterator() {
        if (this.firstChild == null) {
            return NodeIterator.EMPTY;
        }
        return new NodeIterator(this.firstChild, this.lastChild, false);
    }

    public ReversiblePeekingIterator<Node> getReversedChildIterator() {
        if (this.firstChild == null) {
            return NodeIterator.EMPTY;
        }
        return new NodeIterator(this.firstChild, this.lastChild, true);
    }

    public BasedSequence getChars() {
        return this.chars;
    }

    public void removeChildren() {
        Node child = this.firstChild;
        while (child != null) {
            Node nextChild = child.getNext();
            child.unlink();
            child = nextChild;
        }
    }

    public boolean hasChildren() {
        return this.firstChild != null;
    }

    public boolean hasOrMoreChildren(int childCount) {
        if (this.firstChild != null) {
            int count = 0;
            for (Node child : this.getChildren()) {
                if (++count < childCount) continue;
                return true;
            }
        }
        return false;
    }

    public Document getDocument() {
        Node node;
        for (node = this; node != null && !(node instanceof Document); node = node.getParent()) {
        }
        return (Document)node;
    }

    public void setChars(BasedSequence chars) {
        this.chars = chars == null ? BasedSequence.NULL : chars;
    }

    public Node getNext() {
        return this.next;
    }

    public int getStartOffset() {
        return this.chars == null ? 0 : this.chars.getStartOffset();
    }

    public int getEndOffset() {
        return this.chars == null ? 0 : this.chars.getEndOffset();
    }

    public int getTextLength() {
        return this.chars == null ? 0 : this.chars.length();
    }

    public Node getPrevious() {
        return this.prev;
    }

    public Node getPreviousAnyNot(Class ... classes) {
        Node node = this.prev;
        if (classes.length > 0) {
            while (node != null && Node.getNodeOfTypeIndex(node, classes) != -1) {
                node = node.prev;
            }
        }
        return node;
    }

    public Node getPreviousAny(Class ... classes) {
        Node node = this.prev;
        if (classes.length > 0) {
            while (node != null && Node.getNodeOfTypeIndex(node, classes) == -1) {
                node = node.prev;
            }
        }
        return node;
    }

    public Node getNextAnyNot(Class ... classes) {
        Node node = this.next;
        if (classes.length > 0) {
            while (node != null && Node.getNodeOfTypeIndex(node, classes) != -1) {
                node = node.next;
            }
        }
        return node;
    }

    public Node getNextAny(Class ... classes) {
        Node node = this.next;
        if (classes.length > 0) {
            while (node != null && Node.getNodeOfTypeIndex(node, classes) == -1) {
                node = node.next;
            }
        }
        return node;
    }

    public Node getFirstChild() {
        return this.firstChild;
    }

    public Node getFirstChildAnyNot(Class ... classes) {
        Node node = this.firstChild;
        if (classes.length > 0) {
            while (node != null && Node.getNodeOfTypeIndex(node, classes) != -1) {
                node = node.next;
            }
        }
        return node;
    }

    public Node getFirstChildAny(Class ... classes) {
        Node node = this.firstChild;
        if (classes.length > 0) {
            while (node != null && Node.getNodeOfTypeIndex(node, classes) == -1) {
                node = node.next;
            }
        }
        return node;
    }

    public Node getLastChild() {
        return this.lastChild;
    }

    public Node getLastChildAnyNot(Class ... classes) {
        Node node = this.lastChild;
        if (classes.length > 0) {
            while (node != null && Node.getNodeOfTypeIndex(node, classes) != -1) {
                node = node.prev;
            }
        }
        return node;
    }

    public Node getLastChildAny(Class ... classes) {
        Node node = this.lastChild;
        if (classes.length > 0) {
            while (node != null && Node.getNodeOfTypeIndex(node, classes) == -1) {
                node = node.prev;
            }
        }
        return node;
    }

    public Node getParent() {
        return this.parent;
    }

    protected void setParent(Node parent) {
        this.parent = parent;
    }

    public void appendChild(Node child) {
        child.unlink();
        child.setParent(this);
        if (this.lastChild != null) {
            this.lastChild.next = child;
            child.prev = this.lastChild;
            this.lastChild = child;
        } else {
            this.firstChild = child;
            this.lastChild = child;
        }
    }

    public void prependChild(Node child) {
        child.unlink();
        child.setParent(this);
        if (this.firstChild != null) {
            this.firstChild.prev = child;
            child.next = this.firstChild;
            this.firstChild = child;
        } else {
            this.firstChild = child;
            this.lastChild = child;
        }
    }

    public void unlink() {
        if (this.prev != null) {
            this.prev.next = this.next;
        } else if (this.parent != null) {
            this.parent.firstChild = this.next;
        }
        if (this.next != null) {
            this.next.prev = this.prev;
        } else if (this.parent != null) {
            this.parent.lastChild = this.prev;
        }
        this.parent = null;
        this.next = null;
        this.prev = null;
    }

    public void insertAfter(Node sibling) {
        sibling.unlink();
        sibling.next = this.next;
        if (sibling.next != null) {
            sibling.next.prev = sibling;
        }
        sibling.prev = this;
        this.next = sibling;
        sibling.parent = this.parent;
        if (sibling.next == null) {
            sibling.parent.lastChild = sibling;
        }
    }

    public void insertBefore(Node sibling) {
        sibling.unlink();
        sibling.prev = this.prev;
        if (sibling.prev != null) {
            sibling.prev.next = sibling;
        }
        sibling.next = this;
        this.prev = sibling;
        sibling.parent = this.parent;
        if (sibling.prev == null) {
            sibling.parent.firstChild = sibling;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.toStringAttributes() + "}";
    }

    public void getAstExtra(StringBuilder out) {
    }

    public void astExtraChars(StringBuilder out) {
        if (this.getChars().length() > 0) {
            if (this.getChars().length() <= 10) {
                Node.segmentSpanChars(out, this.getChars(), "chars");
            } else {
                Node.segmentSpanChars(out, this.getChars().getStartOffset(), this.getChars().getEndOffset(), "chars", this.getChars().subSequence(0, 5).toVisibleWhitespaceString(), SPLICE, this.getChars().subSequence(this.getChars().length() - 5).toVisibleWhitespaceString());
            }
        }
    }

    public static void astChars(StringBuilder out, CharSequence chars, String name) {
        if (chars.length() > 0) {
            if (chars.length() <= 10) {
                out.append(' ').append(name).append(" \"").append(chars).append("\"");
            } else {
                out.append(' ').append(name).append(" \"").append(chars.subSequence(0, 5)).append(SPLICE).append(chars.subSequence(chars.length() - 5, chars.length())).append("\"");
            }
        }
    }

    protected String toStringAttributes() {
        return "";
    }

    public abstract BasedSequence[] getSegments();

    public static BasedSequence getLeadSegment(BasedSequence[] segments) {
        for (BasedSequence segment : segments) {
            if (segment == null || segment == BasedSequence.NULL) continue;
            return segment;
        }
        return BasedSequence.NULL;
    }

    public static BasedSequence getTrailSegment(BasedSequence[] segments) {
        int iMax;
        int i = iMax = segments.length;
        while (i-- > 0) {
            BasedSequence segment = segments[i];
            if (segment == null || segment == BasedSequence.NULL) continue;
            return segment;
        }
        return BasedSequence.NULL;
    }

    public static BasedSequence spanningChars(BasedSequence ... segments) {
        int startOffset = Integer.MAX_VALUE;
        int endOffset = -1;
        BasedSequence firstSequence = null;
        BasedSequence lastSequence = null;
        for (BasedSequence segment : segments) {
            if (segment == null || segment == BasedSequence.NULL) continue;
            if (startOffset > segment.getStartOffset()) {
                startOffset = segment.getStartOffset();
                firstSequence = segment;
            }
            if (endOffset > segment.getEndOffset()) continue;
            endOffset = segment.getEndOffset();
            lastSequence = segment;
        }
        if (firstSequence != null && lastSequence != null) {
            return firstSequence.baseSubSequence(firstSequence.getStartOffset(), lastSequence.getEndOffset());
        }
        return BasedSequence.NULL;
    }

    public void setCharsFromContentOnly() {
        this.chars = SubSequence.NULL;
        this.setCharsFromContent();
    }

    public void setCharsFromContent() {
        BasedSequence[] segments = this.getSegments();
        BasedSequence spanningChars = null;
        if (segments.length > 0) {
            BasedSequence leadSegment = Node.getLeadSegment(segments);
            BasedSequence trailSegment = Node.getTrailSegment(segments);
            if (this.firstChild == null || this.lastChild == null) {
                BasedSequence[] sequences = new BasedSequence[]{leadSegment, trailSegment};
                spanningChars = Node.spanningChars(sequences);
            } else {
                BasedSequence[] sequences = new BasedSequence[]{leadSegment, trailSegment, this.firstChild.chars, this.lastChild.chars};
                spanningChars = Node.spanningChars(sequences);
            }
        } else if (this.firstChild != null && this.lastChild != null) {
            BasedSequence[] sequences = new BasedSequence[]{this.firstChild.chars, this.lastChild.chars};
            spanningChars = Node.spanningChars(sequences);
        }
        if (spanningChars != null) {
            if (this.chars.isNull()) {
                this.setChars(spanningChars);
            } else {
                int start = Utils.min(this.chars.getStartOffset(), spanningChars.getStartOffset());
                int end = Utils.max(this.chars.getEndOffset(), spanningChars.getEndOffset());
                this.setChars(this.chars.baseSubSequence(start, end));
            }
        }
    }

    protected BasedSequence deNullify(BasedSequence nullable) {
        return nullable == null ? BasedSequence.NULL : nullable;
    }

    public static void segmentSpan(StringBuilder out, int startOffset, int endOffset, String name) {
        if (name != null && !name.trim().isEmpty()) {
            out.append(" ").append(name).append(":");
        }
        out.append("[").append(startOffset).append(", ").append(endOffset).append("]");
    }

    public static void segmentSpanChars(StringBuilder out, int startOffset, int endOffset, String name, String chars) {
        Node.segmentSpanChars(out, startOffset, endOffset, name, chars, "", "");
    }

    public static void segmentSpanChars(StringBuilder out, int startOffset, int endOffset, String name, String chars1, String splice, String chars2) {
        if (name != null && !name.trim().isEmpty()) {
            out.append(" ").append(name).append(":");
        }
        out.append("[").append(startOffset).append(", ").append(endOffset);
        if (startOffset < endOffset) {
            out.append(", \"");
            Node.escapeJavaString(out, chars1);
            out.append(splice);
            Node.escapeJavaString(out, chars2);
            out.append("\"");
        }
        out.append("]");
    }

    private static void escapeJavaString(StringBuilder out, String chars) {
        int iMax = chars.length();
        block9: for (int i = 0; i < iMax; ++i) {
            char c = chars.charAt(i);
            switch (c) {
                case '\"': {
                    out.append("\\\"");
                    continue block9;
                }
                case '\n': {
                    out.append("\\n");
                    continue block9;
                }
                case '\r': {
                    out.append("\\r");
                    continue block9;
                }
                case '\t': {
                    out.append("\\t");
                    continue block9;
                }
                case '\b': {
                    out.append("\\b");
                    continue block9;
                }
                case '\f': {
                    out.append("\\f");
                    continue block9;
                }
                case '\u0000': {
                    out.append("\\0");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        out.append('%').append(String.format("%02x", c));
                        continue block9;
                    }
                    out.append(c);
                }
            }
        }
    }

    public static void segmentSpan(StringBuilder out, BasedSequence sequence, String name) {
        if (sequence.isNotNull()) {
            Node.segmentSpan(out, sequence.getStartOffset(), sequence.getEndOffset(), name);
        }
    }

    public static void segmentSpanChars(StringBuilder out, BasedSequence sequence, String name) {
        if (sequence.isNotNull()) {
            Node.segmentSpanChars(out, sequence.getStartOffset(), sequence.getEndOffset(), name, sequence.toString());
        }
    }

    public static void delimitedSegmentSpan(StringBuilder out, BasedSequence openingSequence, BasedSequence sequence, BasedSequence closingSequence, String name) {
        Node.segmentSpanChars(out, openingSequence.getStartOffset(), openingSequence.getEndOffset(), name + "Open", openingSequence.toString());
        if (sequence.length() <= 10) {
            Node.segmentSpanChars(out, sequence.getStartOffset(), sequence.getEndOffset(), name, sequence.toVisibleWhitespaceString());
        } else {
            Node.segmentSpanChars(out, sequence.getStartOffset(), sequence.getEndOffset(), name, sequence.subSequence(0, 5).toVisibleWhitespaceString(), SPLICE, sequence.endSequence(sequence.length() - 5).toVisibleWhitespaceString());
        }
        Node.segmentSpanChars(out, closingSequence.getStartOffset(), closingSequence.getEndOffset(), name + "Close", closingSequence.toString());
    }

    public static void delimitedSegmentSpanChars(StringBuilder out, BasedSequence openingSequence, BasedSequence sequence, BasedSequence closingSequence, String name) {
        if (openingSequence.isNotNull()) {
            Node.segmentSpanChars(out, openingSequence.getStartOffset(), openingSequence.getEndOffset(), name + "Open", openingSequence.toString());
        }
        if (sequence.isNotNull()) {
            Node.segmentSpanChars(out, sequence.getStartOffset(), sequence.getEndOffset(), name, sequence.toVisibleWhitespaceString());
        }
        if (closingSequence.isNotNull()) {
            Node.segmentSpanChars(out, closingSequence.getStartOffset(), closingSequence.getEndOffset(), name + "Close", closingSequence.toString());
        }
    }

    public void takeChildren(Node node) {
        if (node.firstChild != null) {
            Node lastChild = node.lastChild;
            Node firstChild = node.firstChild;
            if (lastChild != firstChild) {
                node.firstChild = null;
                node.lastChild = null;
                firstChild.parent = this;
                lastChild.parent = this;
                if (this.lastChild != null) {
                    this.lastChild.next = firstChild;
                    firstChild.prev = this.lastChild;
                } else {
                    this.firstChild = firstChild;
                }
                this.lastChild = lastChild;
            } else {
                this.appendChild(firstChild);
            }
        }
    }

    public String getNodeName() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1);
    }

    public void astString(StringBuilder out, boolean withExtra) {
        out.append(this.getNodeName());
        out.append("[").append(this.getStartOffset()).append(", ").append(this.getEndOffset()).append("]");
        if (withExtra) {
            this.getAstExtra(out);
        }
    }

    public String toAstString(boolean withExtra) {
        StringBuilder sb = new StringBuilder();
        this.astString(sb, withExtra);
        return sb.toString();
    }

    public static String toSegmentSpan(BasedSequence sequence, String name) {
        StringBuilder out = new StringBuilder();
        Node.segmentSpan(out, sequence, name);
        return out.toString();
    }

    public BasedSequence getChildChars() {
        if (this.firstChild == null || this.lastChild == null) {
            return BasedSequence.NULL;
        }
        return this.firstChild.getChars().baseSubSequence(this.firstChild.getStartOffset(), this.lastChild.getEndOffset());
    }

    public Node getBlankLineSibling() {
        Node parent = this.parent;
        Node lastBlankLineSibling = null;
        Node nextBlankLineSibling = this;
        while (parent.parent != null) {
            boolean wasLastItem;
            boolean bl = wasLastItem = parent == parent.parent.getLastChildAnyNot(BlankLine.class);
            if (!wasLastItem) break;
            lastBlankLineSibling = nextBlankLineSibling;
            if (parent instanceof BlankLineContainer) {
                nextBlankLineSibling = parent;
            }
            if ((parent = parent.parent) != null) continue;
            break;
        }
        return lastBlankLineSibling;
    }

    public void moveTrailingBlankLines() {
        Node blankLineSibling;
        Node blankLine = this.getLastChild();
        if (blankLine instanceof BlankLine && (blankLineSibling = this.getBlankLineSibling()) != null) {
            while (blankLine instanceof BlankLine) {
                Node node = blankLine.getPrevious();
                blankLine.unlink();
                blankLineSibling.insertAfter(blankLine);
                blankLine = node;
            }
            this.setCharsFromContentOnly();
            blankLineSibling.getParent().setCharsFromContentOnly();
        }
    }
}

