/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.distance;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.operation.distance.FacetSequence;
import java.util.ArrayList;
import java.util.List;

public class FacetSequenceTreeBuilder {
    private static final int FACET_SEQUENCE_SIZE = 6;
    private static final int STR_TREE_NODE_CAPACITY = 4;

    public static STRtree build(Geometry g) {
        STRtree tree = new STRtree(4);
        List sections = FacetSequenceTreeBuilder.computeFacetSequences(g);
        for (FacetSequence section : sections) {
            tree.insert(section.getEnvelope(), (Object)section);
        }
        tree.build();
        return tree;
    }

    private static List computeFacetSequences(Geometry g) {
        final ArrayList sections = new ArrayList();
        g.apply(new GeometryComponentFilter(){

            public void filter(Geometry geom) {
                CoordinateSequence seq = null;
                if (geom instanceof LineString) {
                    seq = ((LineString)geom).getCoordinateSequence();
                    FacetSequenceTreeBuilder.addFacetSequences(seq, sections);
                } else if (geom instanceof Point) {
                    seq = ((Point)geom).getCoordinateSequence();
                    FacetSequenceTreeBuilder.addFacetSequences(seq, sections);
                }
            }
        });
        return sections;
    }

    private static void addFacetSequences(CoordinateSequence pts, List sections) {
        int size = pts.size();
        for (int i = 0; i <= size - 1; i += 6) {
            int end = i + 6 + 1;
            if (end >= size - 1) {
                end = size;
            }
            FacetSequence sect = new FacetSequence(pts, i, end);
            sections.add(sect);
        }
    }
}

