/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.jdbc41;

import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SForwardResultSet;
import com.vertica.jdbc.common.SStatement;
import com.vertica.jdbc.jdbc41.S41ForwardResultSet;
import com.vertica.jdbc.jdbc41.S41UpdatableForwardResultSet;
import com.vertica.support.LogUtilities;
import com.vertica.utilities.JDBCVersion;
import java.sql.ResultSet;
import java.sql.SQLException;

public class S41Statement
extends SStatement {
    public S41Statement(IStatement statement, SConnection conn, int concurrency) {
        super(statement, conn, concurrency);
        this.m_jdbcVersion = JDBCVersion.JDBC41;
    }

    @Override
    protected ResultSet createResultSet(IResultSet internalResultSet, boolean updatable, int fetchSize) throws SQLException {
        SForwardResultSet resultSet = updatable ? new S41UpdatableForwardResultSet(this, internalResultSet, this.getLogger()) : new S41ForwardResultSet(this, internalResultSet, this.getLogger());
        resultSet.setFetchSize(fetchSize);
        return resultSet;
    }

    @Override
    public synchronized void closeOnCompletion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            this.m_closeOnCompletion = true;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public synchronized boolean isCloseOnCompletion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            return this.m_closeOnCompletion;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }
}

