/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.common;

import com.vertica.dsi.core.impl.DSIDriverFactory;
import com.vertica.dsi.core.impl.DSIDriverSingleton;
import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.core.interfaces.IDriver;
import com.vertica.dsi.core.utilities.ConnSettingRequestMap;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.BaseConnectionFactory;
import com.vertica.jdbc.common.JDBCObjectFactory;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SWarningListener;
import com.vertica.jdbc.common.utilities.WrapperUtilities;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogLevel;
import com.vertica.support.Pair;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.utilities.FunctionID;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public abstract class AbstractDataSource
extends BaseConnectionFactory
implements DataSource,
ConnectionPoolDataSource {
    private static boolean s_isInitialized = false;
    private String m_url = null;
    private String m_password = null;
    private String m_userID = null;
    private LogLevel m_logLevel = LogLevel.OFF;
    private String m_logDirectory = "";
    private Map<String, String> m_customProperties = new HashMap<String, String>();

    public static void initialize(String dsiiDriver) {
        DSIDriverFactory.setDriverClassName(dsiiDriver);
        s_isInitialized = true;
    }

    @Override
    public Connection getConnection() throws SQLException {
        SConnection conn = this.getSimbaConnection();
        assert (null != conn);
        return conn;
    }

    @Override
    public Connection getConnection(String userName, String password) throws SQLException {
        this.m_userID = userName;
        this.m_password = password;
        return this.getConnection();
    }

    public String getCustomProperty(String key) {
        return this.m_customProperties.get(key);
    }

    public String getLogDirectory() {
        return this.m_logDirectory;
    }

    @Override
    public int getLoginTimeout() {
        return DriverManager.getLoginTimeout();
    }

    public LogLevel getLogLevel() {
        return this.m_logLevel;
    }

    @Override
    public PrintWriter getLogWriter() {
        return DriverManager.getLogWriter();
    }

    public String getPassword() {
        return this.m_password;
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        SConnection connection = this.getSimbaConnection();
        if (null != connection) {
            return JDBCObjectFactory.getInstance().createPooledConnection(connection);
        }
        SWarningListener warningListener = new SWarningListener(DSIDriverSingleton.getInstance().getMessageSource(), null);
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_REFUSED, (IWarningListener)warningListener, ExceptionType.NON_TRANSIENT_CONNECTION, new Object[0]);
    }

    @Override
    public PooledConnection getPooledConnection(String userName, String password) throws SQLException {
        this.m_userID = userName;
        this.m_password = password;
        return this.getPooledConnection();
    }

    public String getUserID() {
        return this.m_userID;
    }

    public void removeCustomProperty(String key) {
        this.m_customProperties.remove(key);
    }

    public void setCustomProperty(String key, String value) {
        this.m_customProperties.put(key, value);
    }

    public void setLogDirectory(String logDirectory) {
        this.m_logDirectory = logDirectory;
    }

    @Override
    public void setLoginTimeout(int seconds) {
        DriverManager.setLoginTimeout(seconds);
    }

    public void setLogLevel(String level) {
        this.m_logLevel = LogLevel.getLogLevel(level);
    }

    @Override
    public void setLogWriter(PrintWriter writer) {
        DriverManager.setLogWriter(writer);
    }

    public void setPassword(String pass) {
        this.m_password = pass;
    }

    public void setURL(String url) {
        this.m_url = url;
    }

    public void setUserID(String id) {
        this.m_userID = id;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return WrapperUtilities.isWrapperFor(iface, this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return WrapperUtilities.unwrap(iface, this);
    }

    protected Properties getProperties() {
        Properties props = new Properties();
        String uidKey = "USER";
        String pwdKey = "PASSWORD";
        IDriver driver = DSIDriverSingleton.getInstance();
        assert (null != driver);
        try {
            Variant var = driver.getProperty(1000);
            if (1 == var.getShort()) {
                uidKey = "UID";
                pwdKey = "PWD";
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (null != this.m_userID) {
            props.put(uidKey, this.m_userID);
        } else {
            props.put(uidKey, "");
        }
        if (null != this.m_password) {
            props.put(pwdKey, this.m_password);
        } else {
            props.put(pwdKey, "");
        }
        if (null != this.m_logLevel) {
            props.put("LogLevel", this.m_logLevel.name());
        }
        if (null != this.m_logDirectory) {
            props.put("LogPath", this.m_logDirectory);
        }
        props.putAll(this.m_customProperties);
        return props;
    }

    @Override
    protected abstract String getSubProtocol();

    private void doInitialize() throws SQLException {
        if (!s_isInitialized) {
            ExceptionConverter.getInstance().toSQLException("HY000", "Class has not been initialized. Please initialize by calling AbstractDriver.initialize()", 0, ExceptionType.DEFAULT);
        } else if (null == DSIDriverSingleton.getInstance()) {
            try {
                DSIDriverSingleton.setInstance(DSIDriverFactory.createDriver());
            }
            catch (Exception e) {
                SQLException se = new SQLException(e.getLocalizedMessage());
                se.initCause(e);
                throw se;
            }
        }
    }

    private SConnection getSimbaConnection() throws SQLException {
        this.doInitialize();
        Properties info = this.getProperties();
        if (!this.acceptsURL(this.getURL(), info)) {
            IDriver driver = DSIDriverSingleton.getInstance();
            assert (null != driver);
            SWarningListener warningListener = new SWarningListener(driver.getMessageSource(), FunctionID.BEFORE_CONNECTION);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_WRONG_PROPS, (IWarningListener)warningListener, ExceptionType.NON_TRANSIENT_CONNECTION, new Object[0]);
        }
        Pair<IConnection, ConnSettingRequestMap> connInfo = this.getConnection(info);
        return this.doConnect(connInfo, this.getURL());
    }

    private String getURL() throws SQLException {
        if (null != this.m_url) {
            return this.m_url;
        }
        StringBuffer url = new StringBuffer("jdbc");
        url.append(":").append(this.getSubProtocol());
        return url.toString();
    }
}

