/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.utilities;

import com.vertica.dsi.utilities.CalendarSetter;
import java.sql.Timestamp;
import java.util.Calendar;

public class TimestampTz
extends Timestamp {
    private static final long serialVersionUID = -5521593264075626189L;
    private Calendar m_timezoneCal;

    public TimestampTz(Timestamp timestamp, Calendar timezoneCal) {
        super(timestamp.getTime());
        this.setNanos(timestamp.getNanos());
        this.m_timezoneCal = null == timezoneCal ? Calendar.getInstance() : timezoneCal;
    }

    public TimestampTz(long timeMillis, Calendar timezoneCal) {
        super(timeMillis);
        this.m_timezoneCal = null == timezoneCal ? Calendar.getInstance() : timezoneCal;
    }

    public TimestampTz(long timeMillis, int nanos, Calendar timezoneCal) {
        super(timeMillis);
        this.setNanos(nanos);
        this.m_timezoneCal = null == timezoneCal ? Calendar.getInstance() : timezoneCal;
    }

    @Override
    public boolean equals(Object ts) {
        if (!super.equals(ts)) {
            return false;
        }
        if (ts instanceof TimestampTz) {
            TimestampTz other = (TimestampTz)ts;
            return this.m_timezoneCal.getTimeZone().getOffset(this.getTime()) == other.getTimezoneCalendar().getTimeZone().getOffset(other.getTime());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 7 * this.m_timezoneCal.getTimeZone().getOffset(this.getTime());
    }

    public synchronized Timestamp getAdjustedTimestamp() {
        return CalendarSetter.getTimestamp(this, Calendar.getInstance(), this.m_timezoneCal);
    }

    public Calendar getTimezoneCalendar() {
        return this.m_timezoneCal;
    }

    @Override
    public Object clone() {
        TimestampTz t = (TimestampTz)super.clone();
        if (this.m_timezoneCal != null) {
            t.m_timezoneCal = (Calendar)this.m_timezoneCal.clone();
        }
        return t;
    }
}

