/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.impl;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.dataengine.impl.DSISimpleResultSet;
import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.dsi.dataengine.utilities.ColumnMetadata;
import com.vertica.dsi.dataengine.utilities.DSITypeUtilities;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.dsi.dataengine.utilities.TypeUtilities;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import java.util.ArrayList;
import java.util.Iterator;

class DSIArrayResultSet
extends DSISimpleResultSet {
    private static final String INDEX_COLUMN_NAME = "INDEX";
    private static final String VALUE_COLUMN_NAME = "VALUE";
    private final long m_startIndex;
    private final long m_maxSize;
    private long m_currentRow = -1L;
    private Iterator<?> m_iterator;
    private Object m_data;
    private ArrayList<? extends IColumn> m_selectColumns;
    private TypeMetadata m_typeMetadata;

    DSIArrayResultSet(Iterator<?> iterator, IColumn valueColumn, long offset, int count) {
        if (null == iterator) {
            throw new NullPointerException("iterator");
        }
        if (0L > offset) {
            throw new IndexOutOfBoundsException("offset: " + offset);
        }
        if (0 > count && -1 != count) {
            throw new IllegalArgumentException("count: " + count);
        }
        this.m_iterator = iterator;
        this.m_startIndex = offset + 1L;
        this.m_maxSize = count;
        this.m_selectColumns = DSIArrayResultSet.initializeSelectColumns(valueColumn);
        this.m_typeMetadata = valueColumn.getTypeMetadata();
    }

    @Override
    public boolean getData(int column, long offset, long maxSize, DataWrapper retrievedData) throws ErrorException {
        if (0L > this.m_currentRow) {
            throw new IllegalStateException();
        }
        switch (column) {
            case 0: {
                retrievedData.setBigInt(this.m_startIndex + this.m_currentRow);
                return false;
            }
            case 1: {
                short type = this.m_typeMetadata.getType();
                if (null == this.m_data) {
                    retrievedData.setNull(type);
                    return false;
                }
                try {
                    if (TypeUtilities.isCharacterType(type)) {
                        String value = (String)this.m_data;
                        long charOffset = offset / 2L;
                        long maxChars = -1L != maxSize ? maxSize / 2L : maxSize;
                        return DSITypeUtilities.outputString(value, retrievedData, charOffset, maxChars, type);
                    }
                    if (TypeUtilities.isBinaryType(type)) {
                        byte[] value = (byte[])this.m_data;
                        return DSITypeUtilities.outputBytes(value, retrievedData, offset, maxSize, type);
                    }
                    retrievedData.setData(type, this.m_data);
                    return false;
                }
                catch (ClassCastException e) {
                    throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DATA_TYPE_MISMATCH.name(), new String[]{String.valueOf(type), this.m_data.getClass().getName()});
                }
                catch (IncorrectTypeException e) {
                    throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DATA_TYPE_MISMATCH.name(), new String[]{String.valueOf(type), this.m_data.getClass().getName()});
                }
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_COLNUM.name(), String.valueOf(column + 1), ExceptionType.DATA);
    }

    @Override
    public long getRowCount() throws ErrorException {
        return -1L;
    }

    @Override
    public ArrayList<? extends IColumn> getSelectColumns() throws ErrorException {
        return this.m_selectColumns;
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        if (null == this.m_iterator) {
            return false;
        }
        if (-1L != this.m_maxSize && this.m_maxSize <= this.m_currentRow) {
            return false;
        }
        return this.m_iterator.hasNext();
    }

    @Override
    public boolean hasRowCount() {
        return false;
    }

    @Override
    protected void doCloseCursor() throws ErrorException {
        this.m_iterator = null;
        this.m_currentRow = -1L;
    }

    @Override
    protected boolean doMoveToNextRow() throws ErrorException {
        if (this.hasMoreRows()) {
            ++this.m_currentRow;
            this.m_data = this.m_iterator.next();
            return true;
        }
        return false;
    }

    private static ArrayList<ColumnMetadata> initializeSelectColumns(IColumn valueColumn) {
        ColumnMetadata indexMetadata;
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>(2);
        try {
            indexMetadata = new ColumnMetadata(TypeMetadata.createTypeMetadata(-5, false));
        }
        catch (ErrorException e) {
            throw new AssertionError((Object)e);
        }
        indexMetadata.setName(INDEX_COLUMN_NAME);
        indexMetadata.setLabel(INDEX_COLUMN_NAME);
        columns.add(indexMetadata);
        ColumnMetadata valueMetadata = ColumnMetadata.copyOf(valueColumn);
        valueMetadata.setName(VALUE_COLUMN_NAME);
        valueMetadata.setLabel(VALUE_COLUMN_NAME);
        columns.add(valueMetadata);
        return columns;
    }
}

