/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dataengine;

import com.vertica.dataengine.ColumnDescription;
import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.dsi.exceptions.NumericOverflowException;
import com.vertica.util.BaseDataOID;
import com.vertica.util.ClientErrorException;
import java.util.ArrayList;
import java.util.ListIterator;

public class ComplexTypeColumnDescription
extends ColumnDescription {
    private final ArrayList<ColumnDescription> m_childColumns;

    public ComplexTypeColumnDescription(String string, String string2, String string3, String string4, int n, int n2, int n3, int n4, int n5, String string5, int n6, long l, int n7) throws NumericOverflowException, ClientErrorException {
        super(string, string2, string3, string4, n, n2, n3, n4, n5, string5, n6, l, n7);
        this.m_childColumns = new ArrayList(ComplexTypeColumnDescription.predictNumberOfChildColumns(n));
    }

    private static int predictNumberOfChildColumns(int n) {
        if (BaseDataOID.isArrayType(n) || BaseDataOID.isSetType(n)) {
            return 1;
        }
        if (BaseDataOID.isMapType(n)) {
            return 2;
        }
        if (BaseDataOID.isRowType(n)) {
            return 4;
        }
        return 0;
    }

    @Override
    public void addChildColumn(ColumnDescription columnDescription) throws ClientErrorException {
        this.m_childColumns.add(columnDescription);
        TypeMetadata typeMetadata = this.getTypeMetadata();
        ArrayList<IColumn> arrayList = typeMetadata.getNestedColumnList();
        arrayList.add(columnDescription);
    }

    @Override
    public ListIterator<ColumnDescription> getChildColumnIterator() {
        if (this.m_childColumns == null || this.m_childColumns.isEmpty()) {
            return null;
        }
        return this.m_childColumns.listIterator();
    }
}

