/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.processor.support;

import com.usthe.sureness.processor.BaseProcessor;
import com.usthe.sureness.processor.exception.ExpiredCredentialsException;
import com.usthe.sureness.processor.exception.IncorrectCredentialsException;
import com.usthe.sureness.processor.exception.SurenessAuthenticationException;
import com.usthe.sureness.subject.Subject;
import com.usthe.sureness.subject.support.JwtSubject;
import com.usthe.sureness.subject.support.SinglePrincipalMap;
import com.usthe.sureness.util.JsonWebTokenUtil;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.security.SignatureException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtProcessor
extends BaseProcessor {
    private static final Logger logger = LoggerFactory.getLogger(JwtProcessor.class);

    @Override
    public boolean canSupportSubjectClass(Class<?> var) {
        return var == JwtSubject.class;
    }

    @Override
    public Class<?> getSupportSubjectClass() {
        return JwtSubject.class;
    }

    @Override
    public Subject authenticated(Subject var) throws SurenessAuthenticationException {
        Claims claims;
        String jwt = (String)var.getCredential();
        if (JsonWebTokenUtil.isNotJsonWebToken(jwt)) {
            throw new IncorrectCredentialsException("this jwt credential is illegal");
        }
        try {
            claims = JsonWebTokenUtil.parseJwt(jwt);
        }
        catch (MalformedJwtException | UnsupportedJwtException | SignatureException | IllegalArgumentException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("jwtProcessor authenticated fail, user: {}, jwt: {}", var.getPrincipal(), (Object)jwt);
            }
            throw new IncorrectCredentialsException("this jwt error:" + e.getMessage());
        }
        catch (ExpiredJwtException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("jwtProcessor authenticated expired, user: {}, jwt: {}", var.getPrincipal(), (Object)jwt);
            }
            throw new ExpiredCredentialsException("this jwt has expired");
        }
        var.setPrincipal(claims.getSubject());
        List ownRoles = (List)claims.get("roles", List.class);
        if (ownRoles != null) {
            var.setOwnRoles(ownRoles);
        }
        SinglePrincipalMap principalMap = new SinglePrincipalMap();
        for (Map.Entry claimEntry : claims.entrySet()) {
            principalMap.setPrincipal((String)claimEntry.getKey(), claimEntry.getValue());
        }
        var.setPrincipalMap(principalMap);
        return var;
    }
}

