/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.mgt;

import com.usthe.sureness.handler.HandlerManager;
import com.usthe.sureness.matcher.TreePathRoleMatcher;
import com.usthe.sureness.mgt.SecurityManager;
import com.usthe.sureness.mgt.SurenessNoInitException;
import com.usthe.sureness.processor.ProcessorManager;
import com.usthe.sureness.processor.exception.BaseSurenessException;
import com.usthe.sureness.processor.exception.UnsupportedSubjectException;
import com.usthe.sureness.subject.Subject;
import com.usthe.sureness.subject.SubjectFactory;
import com.usthe.sureness.subject.SubjectSum;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurenessSecurityManager
implements SecurityManager {
    private static final Logger logger = LoggerFactory.getLogger(SurenessSecurityManager.class);
    private SubjectFactory subjectFactory;
    private TreePathRoleMatcher pathRoleMatcher;
    private ProcessorManager processorManager;
    private HandlerManager handlerManager;

    private SurenessSecurityManager() {
    }

    private void checkComponentInit() {
        if (this.subjectFactory == null || this.pathRoleMatcher == null || this.processorManager == null) {
            logger.error("SecurityManager init error : SurenessSecurityManager not init fill component");
            throw new SurenessNoInitException("SurenessSecurityManager not init fill component");
        }
    }

    @Override
    public SubjectSum checkIn(Object request) throws BaseSurenessException {
        this.checkComponentInit();
        List<Subject> subjectList = this.createSubject(request);
        RuntimeException lastException = UnsupportedSubjectException.getDefaultInstance();
        boolean noTryExcluded = true;
        Subject preSubject = null;
        for (Subject thisSubject : subjectList) {
            try {
                if (noTryExcluded && this.pathRoleMatcher.isExcludedResource(thisSubject)) {
                    return null;
                }
                noTryExcluded = false;
                if (preSubject == null) {
                    this.pathRoleMatcher.matchRole(thisSubject);
                    preSubject = thisSubject;
                } else {
                    thisSubject.setSupportRoles(preSubject.getSupportRoles());
                }
                SubjectSum subjectSum = this.processorManager.process(thisSubject);
                this.handSuccess(subjectSum, request);
                return subjectSum;
            }
            catch (BaseSurenessException e) {
                lastException = e;
            }
        }
        throw lastException;
    }

    private void handSuccess(SubjectSum subjectSum, Object request) {
        if (this.handlerManager != null) {
            this.handlerManager.hand(subjectSum, request);
        }
    }

    @Override
    public List<Subject> createSubject(Object var1) {
        return this.subjectFactory.createSubjects(var1);
    }

    public void setSubjectFactory(SubjectFactory subjectFactory) {
        this.subjectFactory = subjectFactory;
    }

    public void setPathRoleMatcher(TreePathRoleMatcher pathRoleMatcher) {
        this.pathRoleMatcher = pathRoleMatcher;
    }

    public void setProcessorManager(ProcessorManager processorManager) {
        this.processorManager = processorManager;
    }

    public void setHandlerManager(HandlerManager handlerManager) {
        this.handlerManager = handlerManager;
    }

    public SubjectFactory getSubjectFactory() {
        return this.subjectFactory;
    }

    public TreePathRoleMatcher getPathRoleMatcher() {
        return this.pathRoleMatcher;
    }

    public ProcessorManager getProcessorManager() {
        return this.processorManager;
    }

    public HandlerManager getHandlerManager() {
        return this.handlerManager;
    }

    public static SurenessSecurityManager getInstance() {
        return SingleDefaultSecurityManager.INSTANCE;
    }

    private static class SingleDefaultSecurityManager {
        private static final SurenessSecurityManager INSTANCE = new SurenessSecurityManager();

        private SingleDefaultSecurityManager() {
        }
    }
}

