/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.matcher.util;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TirePathTree {
    private static final Logger logger = LoggerFactory.getLogger(TirePathTree.class);
    private static final String NODE_TYPE_PATH_NODE = "pathNode";
    private static final String NODE_TYPE_MAY_PATH_END = "mayPathEnd";
    private static final String NODE_TYPE_METHOD = "methodNode";
    private static final String NODE_TYPE_FILTER_ROLES = "rolesNode";
    private static final String URL_PATH_SPLIT = "/";
    private static final String MATCH_ALL_METHOD = "*";
    private static final String MATCH_ONE_PATH = "*";
    private static final String MATCH_MULTI_PATH = "**";
    private static final int PATH_NODE_NUM_3 = 3;
    private static final int PATH_NODE_NUM_2 = 2;
    private static final Pattern PATH_SPLIT_PATTERN = Pattern.compile("/+");
    private static final Map<String, Pattern> PATTERN_MAP = new HashMap<String, Pattern>(8);
    private volatile Node root = new Node("root");

    public synchronized void buildTree(Set<String> paths) {
        if (logger.isDebugEnabled()) {
            logger.debug("sureness - start buildTree...");
        }
        this.clearTree();
        for (String path : paths) {
            this.insertNode(path, this.root);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("sureness - buildTree finish");
        }
    }

    public synchronized void rebuildTree(Set<String> paths) {
        if (logger.isDebugEnabled()) {
            logger.debug("sureness - start rebuildTree..., try rcu current way");
        }
        Node buildRoot = new Node("root");
        for (String path : paths) {
            this.insertNode(path, buildRoot);
        }
        this.root = buildRoot;
        if (logger.isDebugEnabled()) {
            logger.debug("sureness - rebuildTree finish");
        }
    }

    public void clearTree() {
        if (logger.isDebugEnabled()) {
            logger.debug("sureness - clearTree");
        }
        this.root.getChildren().clear();
    }

    public int getResourceNum() {
        int resourceNum = 0;
        LinkedList<Node> resourceList = new LinkedList<Node>();
        resourceList.add(this.root);
        while (!resourceList.isEmpty()) {
            Node currentNode = (Node)resourceList.poll();
            if (currentNode.getMethodChildren() != null && !currentNode.getMethodChildren().isEmpty()) {
                resourceNum += currentNode.getMethodChildren().size();
            }
            if (currentNode.getChildren() == null || currentNode.getChildren().isEmpty()) continue;
            resourceList.addAll(currentNode.getChildren().values());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("sureness - current PathTree resource num is: {}", (Object)resourceNum);
        }
        return resourceNum;
    }

    public String searchPathFilterRoles(String path) {
        if (path == null || "".equals(path)) {
            return null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("sureness - searchPathFilterRoles, path is {}", (Object)path);
        }
        if (!path.startsWith(URL_PATH_SPLIT)) {
            path = URL_PATH_SPLIT.concat(path);
        }
        path = PATH_SPLIT_PATTERN.matcher(path).replaceAll(URL_PATH_SPLIT);
        String[] tmp = (path = path.substring(1).toLowerCase()).split("===");
        if (tmp.length != 2) {
            return null;
        }
        String[] urlPac = tmp[0].split(URL_PATH_SPLIT);
        String method = tmp[1];
        Node current = this.root;
        return this.searchPathRoleInChildren(current, urlPac, -1, method);
    }

    private String searchPathRole(Node current, String[] urlPac, int currentFlow, String method) {
        if (current == null || urlPac == null || currentFlow >= urlPac.length || currentFlow < 0 || method == null || "".equals(method)) {
            return null;
        }
        String currentNodeData = current.getData();
        if (this.isNoMatchString(currentNodeData, urlPac[currentFlow])) {
            return null;
        }
        if (currentFlow == urlPac.length - 1 && NODE_TYPE_MAY_PATH_END.equals(current.getNodeType())) {
            Node methodNode = current.getMethodChild(method);
            if (methodNode != null) {
                if (NODE_TYPE_METHOD.equals(methodNode.getNodeType())) {
                    return (String)methodNode.getChildren().keySet().iterator().next();
                }
            } else {
                Node nextNode = current.getMethodChild("*");
                if (nextNode != null && NODE_TYPE_METHOD.equals(nextNode.getNodeType())) {
                    return (String)nextNode.getChildren().keySet().iterator().next();
                }
                nextNode = (Node)current.getChildren().get("*");
                if (nextNode != null && NODE_TYPE_MAY_PATH_END.equals(nextNode.getNodeType())) {
                    methodNode = nextNode.getMethodChild(method);
                    Node node = methodNode = methodNode == null ? nextNode.getMethodChild("*") : methodNode;
                    if (methodNode != null && NODE_TYPE_METHOD.equals(methodNode.getNodeType())) {
                        return (String)methodNode.getChildren().keySet().iterator().next();
                    }
                }
                if ((nextNode = (Node)current.getChildren().get(MATCH_MULTI_PATH)) != null && NODE_TYPE_MAY_PATH_END.equals(nextNode.getNodeType())) {
                    methodNode = nextNode.getMethodChild(method);
                    Node node = methodNode = methodNode == null ? nextNode.getMethodChild("*") : methodNode;
                    if (methodNode != null && NODE_TYPE_METHOD.equals(methodNode.getNodeType())) {
                        return (String)methodNode.getChildren().keySet().iterator().next();
                    }
                }
            }
        }
        String matchRole = null;
        if ((currentNodeData.equals(urlPac[currentFlow]) || this.isPatternStr(currentNodeData)) && (matchRole = this.searchPathRoleInChildren(current, urlPac, currentFlow, method)) != null) {
            return matchRole;
        }
        if (currentNodeData.equals("*")) {
            matchRole = this.searchPathRoleInChildren(current, urlPac, currentFlow - 1, method);
            if (matchRole != null) {
                return matchRole;
            }
            matchRole = this.searchPathRoleInChildren(current, urlPac, currentFlow, method);
            if (matchRole != null) {
                return matchRole;
            }
        }
        if (currentNodeData.equals(MATCH_MULTI_PATH)) {
            matchRole = this.searchPathRoleInChildren(current, urlPac, currentFlow - 1, method);
            if (matchRole != null) {
                return matchRole;
            }
            matchRole = this.searchPathRoleInChildren(current, urlPac, currentFlow, method);
            if (matchRole != null) {
                return matchRole;
            }
            matchRole = this.searchPathRole(current, urlPac, currentFlow + 1, method);
        }
        return matchRole;
    }

    private String searchPathRoleInChildren(Node current, String[] urlPac, int currentFlow, String method) {
        Node matchOneNode;
        if (current == null || urlPac == null || currentFlow >= urlPac.length - 1 || currentFlow < -1 || method == null || "".equals(method)) {
            return null;
        }
        String matchRole = null;
        String nextUrlPac = urlPac[currentFlow + 1];
        if (current.getChildren().containsKey(nextUrlPac) && (matchRole = this.searchPathRole((Node)current.getChildren().get(nextUrlPac), urlPac, currentFlow + 1, method)) != null) {
            return matchRole;
        }
        if (current.getPatternChildren() != null) {
            for (String patternChild : current.getPatternChildren()) {
                Node matchPatternNode = (Node)current.getChildren().get(patternChild);
                matchRole = this.searchPathRole(matchPatternNode, urlPac, currentFlow + 1, method);
                if (matchRole == null) continue;
                return matchRole;
            }
        }
        if (current.getChildren().containsKey("*") && (matchRole = this.searchPathRole(matchOneNode = (Node)current.getChildren().get("*"), urlPac, currentFlow + 1, method)) != null) {
            return matchRole;
        }
        if (current.getChildren().containsKey(MATCH_MULTI_PATH)) {
            Node matchAllNode = (Node)current.getChildren().get(MATCH_MULTI_PATH);
            matchRole = this.searchPathRole(matchAllNode, urlPac, currentFlow + 1, method);
        }
        return matchRole;
    }

    private boolean isNoMatchString(String pattern, String pathNode) {
        if (pattern == null && pathNode == null) {
            return false;
        }
        if (pattern == null || pathNode == null) {
            return true;
        }
        if (pattern.equals(pathNode) || "*".equals(pattern) || MATCH_MULTI_PATH.equals(pattern)) {
            return false;
        }
        if (!this.isPatternStr(pattern)) {
            return true;
        }
        Pattern matcher = PATTERN_MAP.get(pattern);
        if (matcher == null) {
            String patternStr = this.makeJavaPatternStr(pattern);
            matcher = Pattern.compile(patternStr);
            PATTERN_MAP.put(pattern, matcher);
        }
        return !matcher.matcher(pathNode).matches();
    }

    private boolean isPatternStr(String str) {
        return str != null && str.contains("*") && !"*".equals(str) && !MATCH_MULTI_PATH.equals(str);
    }

    private String makeJavaPatternStr(String pattern) {
        return pattern.replace("*", "\\S*").replace(".", "\\.").replace("?", "\\?").replace("+", "\\+").replace("$", "\\$").replace("^", "\\^");
    }

    private void insertNode(String path, Node rootNode) {
        Node current;
        if (path == null || "".equals(path)) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("sureness - begin insertNode, path is {}", (Object)path);
        }
        if (!path.startsWith(URL_PATH_SPLIT)) {
            path = URL_PATH_SPLIT.concat(path);
        }
        path = PATH_SPLIT_PATTERN.matcher(path).replaceAll(URL_PATH_SPLIT);
        String[] tmp = (path = path.substring(1)).split("===");
        if (tmp.length != 3) {
            return;
        }
        tmp[0] = tmp[0].toLowerCase();
        String[] urlPac = tmp[0].split(URL_PATH_SPLIT);
        String method = tmp[1].toLowerCase();
        String supportRoles = tmp[2];
        Node pre = current = rootNode;
        for (String urlData : urlPac) {
            if (!current.getChildren().containsKey(urlData)) {
                current.insertChild(urlData);
                if (this.isPatternStr(urlData)) {
                    Pattern pattern = PATTERN_MAP.get(urlData);
                    if (pattern == null) {
                        String patternStr = this.makeJavaPatternStr(urlData);
                        pattern = Pattern.compile(patternStr);
                        PATTERN_MAP.put(urlData, pattern);
                    }
                    current.insertPatternChild(urlData);
                }
            }
            pre = current;
            current = (Node)current.getChildren().get(urlData);
        }
        if ("*".equals(current.getData()) || MATCH_MULTI_PATH.equals(current.getData())) {
            pre.setNodeType(NODE_TYPE_MAY_PATH_END);
        }
        current.setNodeType(NODE_TYPE_MAY_PATH_END);
        if (current.getMethodChildren() != null) {
            if (current.getMethodChildren().containsKey(method)) {
                logger.warn("[sureness]-The path resource: {} has match same resource config, ignore this one.", (Object)path);
                return;
            }
            if (current.getMethodChildren().containsKey("*")) {
                logger.warn("[sureness]-The path resource: {} has match same resource config(* means all http method), ignore this one.", (Object)path);
                return;
            }
        }
        if ((current = current.insertMethodChildren(method)).getChildren().isEmpty()) {
            current.insertChild(supportRoles, NODE_TYPE_FILTER_ROLES);
        } else {
            logger.warn("[sureness]-The path resource: {} already has supportRoles, ignore it.", (Object)path);
        }
    }

    private static class Node {
        private String nodeType;
        private String data;
        private Map<String, Node> children;
        private List<String> patternChildren;
        private Map<String, Node> methodChildren;

        private Node(String data, String nodeType) {
            this.data = data;
            this.nodeType = nodeType;
            this.children = new HashMap<String, Node>();
        }

        private Node(String data) {
            this.data = data;
            this.nodeType = TirePathTree.NODE_TYPE_PATH_NODE;
            this.children = new HashMap<String, Node>();
        }

        private void insertChild(String data) {
            this.children.put(data, new Node(data));
        }

        private void insertChild(String data, String nodeType) {
            this.children.put(data, new Node(data, nodeType));
        }

        private void insertPatternChild(String data) {
            if (this.patternChildren == null) {
                this.patternChildren = new LinkedList<String>();
            }
            this.patternChildren.add(data);
        }

        public Node getMethodChild(String method) {
            return this.methodChildren == null ? null : this.methodChildren.get(method);
        }

        public Map<String, Node> getMethodChildren() {
            return this.methodChildren;
        }

        public Node insertMethodChildren(String method) {
            if (this.methodChildren == null) {
                this.methodChildren = new HashMap<String, Node>(8);
            }
            Node node = new Node(method, TirePathTree.NODE_TYPE_METHOD);
            this.methodChildren.put(method, node);
            return node;
        }

        private String getNodeType() {
            return this.nodeType;
        }

        private void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        private String getData() {
            return this.data;
        }

        private void setData(String data) {
            this.data = data;
        }

        private Map<String, Node> getChildren() {
            return this.children;
        }

        private void setChildren(Map<String, Node> children) {
            this.children = children;
        }

        public List<String> getPatternChildren() {
            return this.patternChildren;
        }
    }
}

