/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.handler;

import com.usthe.sureness.handler.SuccessHandler;
import com.usthe.sureness.subject.SubjectSum;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerManager {
    private static final Logger log = LoggerFactory.getLogger(HandlerManager.class);
    private List<SuccessHandler> successHandlers;

    public void hand(SubjectSum subjectSum, Object request) {
        if (this.successHandlers != null) {
            for (SuccessHandler successHandler : this.successHandlers) {
                try {
                    successHandler.processHandler(subjectSum, request);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void registerHandler(List<SuccessHandler> handlers) {
        if (this.successHandlers == null) {
            this.successHandlers = handlers;
        } else {
            this.successHandlers.addAll(handlers);
        }
    }

    public void registerHandler(SuccessHandler handler) {
        if (this.successHandlers == null) {
            this.successHandlers = new LinkedList<SuccessHandler>();
        }
        this.successHandlers.add(handler);
    }
}

