/*
 * Decompiled with CFR 0.152.
 */
package com.uber.m3.tally;

import com.uber.m3.tally.AbstractBuckets;
import com.uber.m3.tally.HistogramImpl;
import com.uber.m3.util.Duration;
import java.util.Collections;
import java.util.List;

public class ValueBuckets
extends AbstractBuckets<Double> {
    public ValueBuckets(Double[] values) {
        super((Comparable[])values);
    }

    @Override
    public double getValueLowerBoundFor(int bucketIndex) {
        return bucketIndex == 0 ? Double.MIN_VALUE : (Double)this.buckets.get(bucketIndex - 1);
    }

    @Override
    public double getValueUpperBoundFor(int bucketIndex) {
        return bucketIndex < this.buckets.size() ? (Double)this.buckets.get(bucketIndex) : Double.MAX_VALUE;
    }

    @Override
    public int getBucketIndexFor(double value) {
        return HistogramImpl.toBucketIndex(Collections.binarySearch(this.buckets, value));
    }

    @Override
    public List<Double> getValueUpperBounds() {
        return Collections.unmodifiableList(this.buckets);
    }

    @Override
    public Duration getDurationLowerBoundFor(int bucketIndex) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public Duration getDurationUpperBoundFor(int bucketIndex) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public int getBucketIndexFor(Duration value) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public List<Duration> getDurationUpperBounds() {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    @Deprecated
    public Double[] asValues() {
        return this.buckets.toArray(new Double[this.buckets.size()]);
    }

    @Override
    @Deprecated
    public Duration[] asDurations() {
        Duration[] durations = new Duration[this.buckets.size()];
        for (int i = 0; i < durations.length; ++i) {
            durations[i] = Duration.ofNanos((long)((Double)this.buckets.get(i) * 1.0E9));
        }
        return durations;
    }

    public static ValueBuckets linear(double start, double width, int numBuckets) {
        if (numBuckets <= 0) {
            throw new IllegalArgumentException("Must have a positive number of buckets");
        }
        if (width <= 0.0) {
            throw new IllegalArgumentException("Bucket width must be positive");
        }
        Double[] buckets = new Double[numBuckets];
        for (int i = 0; i < numBuckets; ++i) {
            buckets[i] = start + (double)i * width;
        }
        return new ValueBuckets(buckets);
    }

    public static ValueBuckets exponential(double start, double factor, int numBuckets) {
        if (numBuckets <= 0) {
            throw new IllegalArgumentException("Must have a positive number of buckets");
        }
        if (factor <= 1.0) {
            throw new IllegalArgumentException("Factor must be greater than 1");
        }
        Double[] buckets = new Double[numBuckets];
        Double curDuration = start;
        for (int i = 0; i < numBuckets; ++i) {
            buckets[i] = curDuration;
            curDuration = curDuration * factor;
        }
        return new ValueBuckets(buckets);
    }

    public static ValueBuckets custom(double ... sortedBucketUpperValues) {
        if (sortedBucketUpperValues == null || sortedBucketUpperValues.length == 0) {
            throw new IllegalArgumentException("Must have a positive number of buckets");
        }
        for (int i = 0; i < sortedBucketUpperValues.length - 1; ++i) {
            if (!(sortedBucketUpperValues[i] >= sortedBucketUpperValues[i + 1])) continue;
            throw new IllegalArgumentException("bucketUpperValues has to be sorted and unique values in ascending order");
        }
        Double[] buckets = new Double[sortedBucketUpperValues.length];
        for (int i = 0; i < sortedBucketUpperValues.length; ++i) {
            buckets[i] = sortedBucketUpperValues[i];
        }
        return new ValueBuckets(buckets);
    }
}

