/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.tiff;

import com.twelvemonkeys.imageio.plugins.tiff.LZWDecoder;
import com.twelvemonkeys.io.enc.Encoder;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.TreeMap;

final class LZWEncoder
implements Encoder {
    static final int CLEAR_CODE = 256;
    static final int EOI_CODE = 257;
    private static final int MIN_BITS = 9;
    private static final int MAX_BITS = 12;
    private static final int TABLE_SIZE = 4096;
    private final LZWDecoder.LZWString[] table = new LZWDecoder.LZWString[4096];
    private final Map<LZWDecoder.LZWString, Integer> reverseTable = new TreeMap<LZWDecoder.LZWString, Integer>();
    private int tableLength;
    LZWDecoder.LZWString omega = LZWDecoder.LZWString.EMPTY;
    int bitsPerCode;
    private int oldCode = 256;
    private int maxCode;
    int bitMask;
    private int bits = 0;
    private int bitPos = 0;
    private long remaining;

    protected LZWEncoder(int n) {
        this.remaining = n;
        for (int i = 0; i < 256; ++i) {
            this.table[i] = new LZWDecoder.LZWString((byte)i);
        }
        this.init();
    }

    private void init() {
        this.tableLength = 258;
        this.bitsPerCode = 9;
        this.bitMask = LZWEncoder.bitmaskFor(this.bitsPerCode);
        this.maxCode = this.maxCode();
        this.reverseTable.clear();
    }

    public void encode(OutputStream outputStream, ByteBuffer byteBuffer) throws IOException {
        if (this.remaining < 0L) {
            throw new IOException("Write past end of stream");
        }
        if (this.oldCode == 256) {
            this.writeCode(outputStream, 256);
        }
        int n = byteBuffer.remaining();
        while (byteBuffer.hasRemaining()) {
            byte by = byteBuffer.get();
            LZWDecoder.LZWString lZWString = this.omega.concatenate(by);
            int n2 = this.isInTable(lZWString);
            if (n2 >= 0) {
                this.omega = lZWString;
                this.oldCode = n2;
                continue;
            }
            this.writeCode(outputStream, this.oldCode);
            this.addStringToTable(lZWString);
            this.oldCode = by & 0xFF;
            this.omega = this.table[by & 0xFF];
            if (this.tableLength < 4094) continue;
            this.writeCode(outputStream, 256);
            this.init();
        }
        this.remaining -= (long)n;
        if (this.remaining <= 0L) {
            this.writeCode(outputStream, this.oldCode);
            this.writeCode(outputStream, 257);
            if (this.bitPos > 0) {
                this.writeCode(outputStream, 0);
            }
        }
    }

    private int isInTable(LZWDecoder.LZWString lZWString) {
        if (lZWString.length == 1) {
            return lZWString.value & 0xFF;
        }
        Integer n = this.reverseTable.get(lZWString);
        return n != null ? n : -1;
    }

    private int addStringToTable(LZWDecoder.LZWString lZWString) {
        int n = this.tableLength++;
        this.table[n] = lZWString;
        this.reverseTable.put(lZWString, n);
        if (this.tableLength > this.maxCode) {
            ++this.bitsPerCode;
            if (this.bitsPerCode > 12) {
                throw new IllegalStateException(String.format("TIFF LZW with more than %d bits per code encountered (table overflow)", 12));
            }
            this.bitMask = LZWEncoder.bitmaskFor(this.bitsPerCode);
            this.maxCode = this.maxCode();
        }
        return n;
    }

    private void writeCode(OutputStream outputStream, int n) throws IOException {
        this.bits = this.bits << this.bitsPerCode | n & this.bitMask;
        this.bitPos += this.bitsPerCode;
        while (this.bitPos >= 8) {
            int n2 = this.bits >> this.bitPos - 8 & 0xFF;
            outputStream.write(n2);
            this.bitPos -= 8;
        }
        this.bits &= LZWEncoder.bitmaskFor(this.bitPos);
    }

    private static int bitmaskFor(int n) {
        return (1 << n) - 1;
    }

    protected int maxCode() {
        return this.bitMask;
    }
}

