/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.tiff;

import com.twelvemonkeys.lang.Validate;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

final class CCITTFaxDecoderStream
extends FilterInputStream {
    private final int columns;
    private final byte[] decodedRow;
    private int decodedLength;
    private int decodedPos;
    private int bitBuffer;
    private int bitBufferLength;
    private final int fillOrder;
    private final int type;
    private final int[] changes;
    private int changesCount;
    private static final int EOL_CODE = 1;
    static final short[][] BLACK_CODES = new short[][]{{2, 3}, {2, 3}, {2, 3}, {3}, {4, 5}, {4, 5, 7}, {4, 7}, {24}, {23, 24, 55, 8, 15}, {23, 24, 40, 55, 103, 104, 108, 8, 12, 13}, {18, 19, 20, 21, 22, 23, 28, 29, 30, 31, 36, 39, 40, 43, 44, 51, 52, 53, 55, 56, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 200, 201, 202, 203, 204, 205, 210, 211, 212, 213, 214, 215, 218, 219}, {74, 75, 76, 77, 82, 83, 84, 85, 90, 91, 100, 101, 108, 109, 114, 115, 116, 117, 118, 119}};
    static final short[][] BLACK_RUN_LENGTHS = new short[][]{{3, 2}, {1, 4}, {6, 5}, {7}, {9, 8}, {10, 11, 12}, {13, 14}, {15}, {16, 17, 0, 18, 64}, {24, 25, 23, 22, 19, 20, 21, 1792, 1856, 1920}, {1984, 2048, 2112, 2176, 2240, 2304, 2368, 2432, 2496, 2560, 52, 55, 56, 59, 60, 320, 384, 448, 53, 54, 50, 51, 44, 45, 46, 47, 57, 58, 61, 256, 48, 49, 62, 63, 30, 31, 32, 33, 40, 41, 128, 192, 26, 27, 28, 29, 34, 35, 36, 37, 38, 39, 42, 43}, {640, 704, 768, 832, 1280, 1344, 1408, 1472, 1536, 1600, 1664, 1728, 512, 576, 896, 960, 1024, 1088, 1152, 1216}};
    public static final short[][] WHITE_CODES = new short[][]{{7, 8, 11, 12, 14, 15}, {18, 19, 20, 27, 7, 8}, {23, 24, 42, 43, 3, 52, 53, 7, 8}, {19, 23, 24, 36, 39, 40, 43, 3, 55, 4, 8, 12}, {18, 19, 20, 21, 22, 23, 26, 27, 2, 36, 37, 40, 41, 42, 43, 44, 45, 3, 50, 51, 52, 53, 54, 55, 4, 74, 75, 5, 82, 83, 84, 85, 88, 89, 90, 91, 100, 101, 103, 104, 10, 11}, {152, 153, 154, 155, 204, 205, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219}, new short[0], {8, 12, 13}, {18, 19, 20, 21, 22, 23, 28, 29, 30, 31}};
    public static final short[][] WHITE_RUN_LENGTHS = new short[][]{{2, 3, 4, 5, 6, 7}, {128, 8, 9, 64, 10, 11}, {192, 1664, 16, 17, 13, 14, 15, 1, 12}, {26, 21, 28, 27, 18, 24, 25, 22, 256, 23, 20, 19}, {33, 34, 35, 36, 37, 38, 31, 32, 29, 53, 54, 39, 40, 41, 42, 43, 44, 30, 61, 62, 63, 0, 320, 384, 45, 59, 60, 46, 49, 50, 51, 52, 55, 56, 57, 58, 448, 512, 640, 576, 47, 48}, {1472, 1536, 1600, 1728, 704, 768, 832, 896, 960, 1024, 1088, 1152, 1216, 1280, 1344, 1408}, new short[0], {1792, 1856, 1920}, {1984, 2048, 2112, 2176, 2240, 2304, 2368, 2432, 2496, 2560}};

    public CCITTFaxDecoderStream(InputStream inputStream, int n, int n2, int n3) {
        super((InputStream)Validate.notNull((Object)inputStream, (String)"stream"));
        this.columns = (Integer)Validate.isTrue((n > 0 ? 1 : 0) != 0, (Object)n, (String)"width must be greater than 0");
        this.decodedRow = new byte[(n + 7) / 8];
        this.type = (Integer)Validate.isTrue((n2 == 2 ? 1 : 0) != 0, (Object)n2, (String)"Only CCITT Modified Huffman RLE compression (2) supported: %s");
        this.fillOrder = (Integer)Validate.isTrue((n3 == 1 ? 1 : 0) != 0, (Object)n3, (String)"Only fill order 1 supported: %s");
        this.changes = new int[n];
    }

    private void fetch() throws IOException {
        if (this.decodedPos >= this.decodedLength) {
            this.decodedLength = 0;
            try {
                this.decodeRow();
            }
            catch (EOFException eOFException) {
                if (this.decodedLength != 0) {
                    throw eOFException;
                }
                this.decodedLength = -1;
            }
            this.decodedPos = 0;
        }
    }

    private void decodeRow() throws IOException {
        this.resetBuffer();
        boolean bl = true;
        int n = 0;
        if (bl) {
            this.changesCount = 0;
            boolean bl2 = true;
            do {
                int n2;
                int n3 = 0;
                do {
                    n2 = bl2 ? this.decodeRun(WHITE_CODES, WHITE_RUN_LENGTHS, 4) : this.decodeRun(BLACK_CODES, BLACK_RUN_LENGTHS, 2);
                    n3 += n2;
                } while (n2 >= 64);
                this.changes[this.changesCount++] = n + n3;
                while (n % 8 != 0 && n3-- > 0) {
                    int n4 = n++ / 8;
                    this.decodedRow[n4] = (byte)(this.decodedRow[n4] | (bl2 ? 1 << 8 - n % 8 : 0));
                }
                if (n % 8 == 0) {
                    byte by = (byte)(bl2 ? 255 : 0);
                    while (n3 > 7) {
                        this.decodedRow[n / 8] = by;
                        n3 -= 8;
                        n += 8;
                    }
                }
                while (n3-- > 0) {
                    int n5 = n++ / 8;
                    this.decodedRow[n5] = (byte)(this.decodedRow[n5] | (bl2 ? 1 << 8 - n % 8 : 0));
                }
                boolean bl3 = bl2 = !bl2;
            } while (n < this.columns);
        }
        if (this.type == 2 && n != this.columns) {
            throw new IOException("Sum of run-lengths does not equal scan line width: " + n + " > " + this.columns);
        }
        this.decodedLength = (n + 7) / 8;
    }

    private int decodeRun(short[][] sArray, short[][] sArray2, int n) throws IOException {
        int n2 = this.readBits(n);
        for (int i = 0; i < sArray.length; ++i) {
            short[] sArray3 = sArray[i];
            for (int j = 0; j < sArray3.length; ++j) {
                if (sArray3[j] != n2) continue;
                return sArray2[i][j];
            }
            n2 = this.fillOrder == 1 ? n2 << 1 | this.readBits(1) : this.readBits(1) << i + n | n2;
        }
        throw new IOException("Unknown code in Huffman RLE stream");
    }

    private void resetBuffer() {
        for (int i = 0; i < this.decodedRow.length; ++i) {
            this.decodedRow[i] = 0;
        }
        this.bitBuffer = 0;
        this.bitBufferLength = 0;
    }

    private int readBits(int n) throws IOException {
        int n2;
        while (this.bitBufferLength < n) {
            n2 = this.in.read();
            if (n2 == -1) {
                throw new EOFException("Unexpected end of Huffman RLE stream");
            }
            int n3 = n2 & 0xFF;
            this.bitBuffer = this.bitBuffer << 8 | n3;
            this.bitBufferLength += 8;
        }
        this.bitBufferLength -= n;
        n2 = this.bitBuffer >> this.bitBufferLength;
        this.bitBuffer &= (1 << this.bitBufferLength) - 1;
        return n2;
    }

    @Override
    public int read() throws IOException {
        if (this.decodedLength < 0) {
            return -1;
        }
        if (this.decodedPos >= this.decodedLength) {
            this.fetch();
            if (this.decodedLength < 0) {
                return -1;
            }
        }
        return this.decodedRow[this.decodedPos++] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.decodedLength < 0) {
            return -1;
        }
        if (this.decodedPos >= this.decodedLength) {
            this.fetch();
            if (this.decodedLength < 0) {
                return -1;
            }
        }
        int n3 = Math.min(this.decodedLength - this.decodedPos, n2);
        System.arraycopy(this.decodedRow, this.decodedPos, byArray, n, n3);
        this.decodedPos += n3;
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        if (this.decodedLength < 0) {
            return -1L;
        }
        if (this.decodedPos >= this.decodedLength) {
            this.fetch();
            if (this.decodedLength < 0) {
                return -1L;
            }
        }
        int n = (int)Math.min((long)(this.decodedLength - this.decodedPos), l);
        this.decodedPos += n;
        return n;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }
}

