/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.jpeg;

import com.twelvemonkeys.imageio.metadata.jpeg.JPEGSegment;
import com.twelvemonkeys.imageio.plugins.jpeg.AdobeDCTSegment;
import com.twelvemonkeys.imageio.plugins.jpeg.JFIFSegment;
import com.twelvemonkeys.imageio.plugins.jpeg.JFXXSegment;
import com.twelvemonkeys.imageio.plugins.jpeg.JFXXThumbnailReader;
import com.twelvemonkeys.imageio.plugins.jpeg.JPEGImageReader;
import com.twelvemonkeys.imageio.plugins.jpeg.SOFSegment;
import com.twelvemonkeys.xml.XMLSerializer;
import java.awt.color.ICC_Profile;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class JPEGImage10MetadataCleaner {
    static final String JAVAX_IMAGEIO_JPEG_IMAGE_1_0 = "javax_imageio_jpeg_image_1.0";
    private final JPEGImageReader reader;

    JPEGImage10MetadataCleaner(JPEGImageReader jPEGImageReader) {
        this.reader = jPEGImageReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IIOMetadata cleanMetadata(IIOMetadata iIOMetadata) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object7;
        List<JPEGSegment> list = this.reader.getAppSegments(-1, null);
        IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)iIOMetadata.getAsTree(JAVAX_IMAGEIO_JPEG_IMAGE_1_0);
        IIOMetadataNode iIOMetadataNode2 = (IIOMetadataNode)iIOMetadataNode.getElementsByTagName("JPEGvariety").item(0);
        IIOMetadataNode iIOMetadataNode3 = (IIOMetadataNode)iIOMetadataNode.getElementsByTagName("markerSequence").item(0);
        JFIFSegment jFIFSegment = this.reader.getJFIF();
        JFXXSegment jFXXSegment = this.reader.getJFXX();
        AdobeDCTSegment adobeDCTSegment = this.reader.getAdobeDCT();
        ICC_Profile iCC_Profile = this.reader.getEmbeddedICCProfile(true);
        SOFSegment sOFSegment = this.reader.getSOF();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (jFIFSegment != null) {
            if (sOFSegment.componentsInFrame() == 1 || sOFSegment.componentsInFrame() == 3) {
                IIOMetadataNode iIOMetadataNode4;
                object7 = new IIOMetadataNode("app0JFIF");
                ((IIOMetadataNode)object7).setAttribute("majorVersion", String.valueOf(jFIFSegment.majorVersion));
                ((IIOMetadataNode)object7).setAttribute("minorVersion", String.valueOf(jFIFSegment.minorVersion));
                ((IIOMetadataNode)object7).setAttribute("resUnits", String.valueOf(jFIFSegment.units));
                ((IIOMetadataNode)object7).setAttribute("Xdensity", String.valueOf(Math.max(1, jFIFSegment.xDensity)));
                ((IIOMetadataNode)object7).setAttribute("Ydensity", String.valueOf(Math.max(1, jFIFSegment.yDensity)));
                ((IIOMetadataNode)object7).setAttribute("thumbWidth", String.valueOf(jFIFSegment.xThumbnail));
                ((IIOMetadataNode)object7).setAttribute("thumbHeight", String.valueOf(jFIFSegment.yThumbnail));
                iIOMetadataNode2.appendChild((Node)object7);
                bl = true;
                if (iCC_Profile != null) {
                    iIOMetadataNode4 = new IIOMetadataNode("app2ICC");
                    iIOMetadataNode4.setUserObject(iCC_Profile);
                    ((IIOMetadataNode)object7).appendChild(iIOMetadataNode4);
                    bl3 = true;
                }
                if (jFXXSegment != null) {
                    iIOMetadataNode4 = new IIOMetadataNode("JFXX");
                    ((IIOMetadataNode)object7).appendChild(iIOMetadataNode4);
                    IIOMetadataNode object62 = new IIOMetadataNode("app0JFXX");
                    object62.setAttribute("extensionCode", String.valueOf(jFXXSegment.extensionCode));
                    object5 = new JFXXThumbnailReader(null, this.reader.getThumbnailReader(), 0, 0, jFXXSegment);
                    switch (jFXXSegment.extensionCode) {
                        case 16: {
                            object4 = new IIOMetadataNode("JFIFthumbJPEG");
                            object3 = ((JFXXThumbnailReader)object5).readMetadata();
                            object2 = ((IIOMetadata)object3).getAsTree(JAVAX_IMAGEIO_JPEG_IMAGE_1_0);
                            ((IIOMetadataNode)object4).appendChild(object2.getLastChild());
                            object62.appendChild((Node)object4);
                            break;
                        }
                        case 17: {
                            object4 = new IIOMetadataNode("JFIFthumbPalette");
                            ((IIOMetadataNode)object4).setAttribute("thumbWidth", String.valueOf(((JFXXThumbnailReader)object5).getWidth()));
                            ((IIOMetadataNode)object4).setAttribute("thumbHeight", String.valueOf(((JFXXThumbnailReader)object5).getHeight()));
                            object62.appendChild((Node)object4);
                            break;
                        }
                        case 19: {
                            object4 = new IIOMetadataNode("JFIFthumbRGB");
                            ((IIOMetadataNode)object4).setAttribute("thumbWidth", String.valueOf(((JFXXThumbnailReader)object5).getWidth()));
                            ((IIOMetadataNode)object4).setAttribute("thumbHeight", String.valueOf(((JFXXThumbnailReader)object5).getHeight()));
                            object62.appendChild((Node)object4);
                            break;
                        }
                        default: {
                            this.reader.processWarningOccurred(String.format("Unknown JFXX extension code: %d", jFXXSegment.extensionCode));
                        }
                    }
                    iIOMetadataNode4.appendChild(object62);
                    bl2 = true;
                }
            } else {
                this.reader.processWarningOccurred(String.format("Incompatible JFIF marker segment in stream. SOF%d has %d color components, JFIF allows only 1 or 3 components. Ignoring JFIF marker.", sOFSegment.marker & 0xF, sOFSegment.componentsInFrame()));
            }
        }
        if (adobeDCTSegment != null && (adobeDCTSegment.getTransform() == 2 && sOFSegment.componentsInFrame() < 4 || adobeDCTSegment.getTransform() == 1 && sOFSegment.componentsInFrame() < 3)) {
            this.reader.processWarningOccurred(String.format("Invalid Adobe App14 marker. Indicates %s data, but SOF%d has %d color component(s). Ignoring Adobe App14 marker.", adobeDCTSegment.getTransform() == 2 ? "YCCK/CMYK" : "YCC/RGB", sOFSegment.marker & 0xF, sOFSegment.componentsInFrame()));
            object7 = iIOMetadataNode.getElementsByTagName("app14Adobe");
            for (int i = object7.getLength() - 1; i >= 0; --i) {
                Node node = object7.item(i);
                node.getParentNode().removeChild(node);
            }
        }
        object7 = null;
        for (JPEGSegment jPEGSegment : list) {
            if (jPEGSegment.marker() == 65504 && "JFIF".equals(jPEGSegment.identifier()) && bl || jPEGSegment.marker() == 65504 && "JFXX".equals(jPEGSegment.identifier()) && bl2 || jPEGSegment.marker() == 65505 && "Exif".equals(jPEGSegment.identifier()) || jPEGSegment.marker() == 65506 && "ICC_PROFILE".equals(jPEGSegment.identifier()) && bl3 || jPEGSegment.marker() == 65518 && "Adobe".equals(jPEGSegment.identifier())) continue;
            object5 = new IIOMetadataNode("unknown");
            ((IIOMetadataNode)object5).setAttribute("MarkerTag", Integer.toString(jPEGSegment.marker() & 0xFF));
            object4 = new DataInputStream(jPEGSegment.data());
            try {
                object3 = jPEGSegment.identifier();
                int n = object3 != null ? ((String)object3).length() + 1 : 0;
                object = new byte[n + jPEGSegment.length()];
                if (object3 != null) {
                    System.arraycopy(((String)object3).getBytes(Charset.forName("ASCII")), 0, object, 0, ((String)object3).length());
                }
                ((DataInputStream)object4).readFully((byte[])object, n, jPEGSegment.length());
                ((IIOMetadataNode)object5).setUserObject(object);
            }
            finally {
                ((FilterInputStream)object4).close();
            }
            if (object7 == null) {
                object3 = iIOMetadataNode3.getElementsByTagName("unknown");
                object7 = object3.getLength() > 0 ? object3.item(object3.getLength() - 1).getNextSibling() : iIOMetadataNode3.getFirstChild();
            }
            iIOMetadataNode3.insertBefore((Node)object5, (Node)object7);
        }
        NodeList nodeList = iIOMetadataNode3.getElementsByTagName("sof");
        if (nodeList.getLength() > 0) {
            NodeList nodeList2 = nodeList.item(0).getChildNodes();
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                this.forceComponentIdInRange((IIOMetadataNode)nodeList2.item(i), "componentId");
            }
        }
        NodeList nodeList3 = iIOMetadataNode3.getElementsByTagName("sos");
        for (int i = 0; i < nodeList3.getLength(); ++i) {
            object4 = nodeList3.item(i).getChildNodes();
            for (int j = 0; j < object4.getLength(); ++j) {
                this.forceComponentIdInRange((IIOMetadataNode)object4.item(j), "componentSelector");
            }
        }
        NodeList nodeList4 = iIOMetadataNode3.getElementsByTagName("dht");
        for (int i = 0; i < nodeList4.getLength(); ++i) {
            object3 = nodeList4.item(i);
            object2 = object3.getChildNodes();
            if (object2.getLength() < 1) {
                object3.getParentNode().removeChild((Node)object3);
                this.reader.processWarningOccurred("Metadata contains empty dht node. Ignoring.");
                continue;
            }
            if (object2.getLength() <= 4) continue;
            object = new IIOMetadataNode("dht");
            object3.getParentNode().insertBefore((Node)object, object3.getNextSibling());
            for (int j = 0; j < object2.getLength(); ++j) {
                Element element = (Element)object2.item(j);
                String string = element.getAttribute("class");
                if (!"1".equals(string)) continue;
                object3.removeChild(element);
                ((IIOMetadataNode)object).appendChild(element);
            }
        }
        try {
            iIOMetadata.setFromTree(JAVAX_IMAGEIO_JPEG_IMAGE_1_0, iIOMetadataNode);
        }
        catch (IIOInvalidTreeException iIOInvalidTreeException) {
            if (JPEGImageReader.DEBUG) {
                new XMLSerializer((OutputStream)System.out, System.getProperty("file.encoding")).serialize(iIOMetadata.getAsTree(JAVAX_IMAGEIO_JPEG_IMAGE_1_0), false);
                System.out.println("-- 8< --");
                new XMLSerializer((OutputStream)System.out, System.getProperty("file.encoding")).serialize((Node)iIOMetadataNode, false);
            }
            throw iIOInvalidTreeException;
        }
        return iIOMetadata;
    }

    private void forceComponentIdInRange(IIOMetadataNode iIOMetadataNode, String string) {
        String string2 = iIOMetadataNode.getAttribute(string);
        if (string2 != null) {
            try {
                int n = Integer.parseInt(string2);
                if (n < 0) {
                    n = (byte)n & 0xFF;
                    iIOMetadataNode.setAttribute(string, String.valueOf(n));
                }
            }
            catch (NumberFormatException numberFormatException) {
                if ("scanComponentSpec".equals(iIOMetadataNode.getNodeName())) {
                    this.reader.processWarningOccurred("Bad SOS component selector: " + string2);
                }
                this.reader.processWarningOccurred("Bad SOF component id: " + string2);
            }
        }
    }
}

