/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.bmp;

import com.twelvemonkeys.imageio.plugins.bmp.DIBHeader;
import com.twelvemonkeys.imageio.plugins.bmp.DirectoryEntry;
import com.twelvemonkeys.lang.Validate;
import java.awt.image.BufferedImage;

abstract class BitmapDescriptor {
    protected final DirectoryEntry entry;
    protected final DIBHeader header;
    protected BufferedImage image;

    public BitmapDescriptor(DirectoryEntry directoryEntry, DIBHeader dIBHeader) {
        Validate.notNull((Object)directoryEntry, (String)"entry");
        Validate.notNull((Object)dIBHeader, (String)"header");
        this.entry = directoryEntry;
        this.header = dIBHeader;
    }

    public abstract BufferedImage getImage();

    public final int getWidth() {
        return this.entry.getWidth();
    }

    public final int getHeight() {
        return this.entry.getHeight();
    }

    protected final int getColorCount() {
        return this.entry.getColorCount() != 0 ? this.entry.getColorCount() : 1 << this.getBitCount();
    }

    protected final int getBitCount() {
        return this.entry.getBitCount() != 0 ? this.entry.getBitCount() : this.header.getBitCount();
    }
}

