/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.tracker;

import com.turn.ttorrent.common.Torrent;
import com.turn.ttorrent.tracker.TrackedTorrent;
import com.turn.ttorrent.tracker.TrackerService;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URL;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.simpleframework.http.core.Container;
import org.simpleframework.transport.connect.Connection;
import org.simpleframework.transport.connect.SocketConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tracker {
    private static final Logger logger = LoggerFactory.getLogger(Tracker.class);
    public static final String ANNOUNCE_URL = "/announce";
    public static final int DEFAULT_TRACKER_PORT = 6969;
    public static final String DEFAULT_VERSION_STRING = "BitTorrent Tracker (ttorrent)";
    private final Connection connection;
    private final InetSocketAddress address;
    private final ConcurrentMap<String, TrackedTorrent> torrents;
    private Thread tracker;
    private Thread collector;
    private boolean stop;

    public Tracker(InetAddress address) throws IOException {
        this(new InetSocketAddress(address, 6969), DEFAULT_VERSION_STRING);
    }

    public Tracker(InetSocketAddress address) throws IOException {
        this(address, DEFAULT_VERSION_STRING);
    }

    public Tracker(InetSocketAddress address, String version) throws IOException {
        this.address = address;
        this.torrents = new ConcurrentHashMap<String, TrackedTorrent>();
        this.connection = new SocketConnection((Container)new TrackerService(version, this.torrents));
    }

    public URL getAnnounceUrl() {
        try {
            return new URL("http", this.address.getAddress().getCanonicalHostName(), this.address.getPort(), ANNOUNCE_URL);
        }
        catch (MalformedURLException mue) {
            logger.error("Could not build tracker URL: {}!", (Object)mue, (Object)mue);
            return null;
        }
    }

    public void start() {
        if (this.tracker == null || !this.tracker.isAlive()) {
            this.tracker = new TrackerThread();
            this.tracker.setName("tracker:" + this.address.getPort());
            this.tracker.start();
        }
        if (this.collector == null || !this.collector.isAlive()) {
            this.collector = new PeerCollectorThread();
            this.collector.setName("peer-collector:" + this.address.getPort());
            this.collector.start();
        }
    }

    public void stop() {
        this.stop = true;
        try {
            this.connection.close();
            logger.info("BitTorrent tracker closed.");
        }
        catch (IOException ioe) {
            logger.error("Could not stop the tracker: {}!", (Object)ioe.getMessage());
        }
        if (this.collector != null && this.collector.isAlive()) {
            this.collector.interrupt();
            logger.info("Peer collection terminated.");
        }
    }

    public Collection<TrackedTorrent> getTrackedTorrents() {
        return this.torrents.values();
    }

    public synchronized TrackedTorrent announce(TrackedTorrent torrent) {
        TrackedTorrent existing = (TrackedTorrent)this.torrents.get(torrent.getHexInfoHash());
        if (existing != null) {
            logger.warn("Tracker already announced torrent for '{}' with hash {}.", (Object)existing.getName(), (Object)existing.getHexInfoHash());
            return existing;
        }
        this.torrents.put(torrent.getHexInfoHash(), torrent);
        logger.info("Registered new torrent for '{}' with hash {}.", (Object)torrent.getName(), (Object)torrent.getHexInfoHash());
        return torrent;
    }

    public synchronized void remove(Torrent torrent) {
        if (torrent == null) {
            return;
        }
        this.torrents.remove(torrent.getHexInfoHash());
    }

    public synchronized void remove(Torrent torrent, long delay) {
        if (torrent == null) {
            return;
        }
        new Timer().schedule((TimerTask)new TorrentRemoveTimer(this, torrent), delay);
    }

    private class PeerCollectorThread
    extends Thread {
        private static final int PEER_COLLECTION_FREQUENCY_SECONDS = 15;

        private PeerCollectorThread() {
        }

        @Override
        public void run() {
            logger.info("Starting tracker peer collection for tracker at {}...", (Object)Tracker.this.getAnnounceUrl());
            while (!Tracker.this.stop) {
                for (TrackedTorrent torrent : Tracker.this.torrents.values()) {
                    torrent.collectUnfreshPeers();
                }
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class TrackerThread
    extends Thread {
        private TrackerThread() {
        }

        @Override
        public void run() {
            logger.info("Starting BitTorrent tracker on {}...", (Object)Tracker.this.getAnnounceUrl());
            try {
                Tracker.this.connection.connect((SocketAddress)Tracker.this.address);
            }
            catch (IOException ioe) {
                logger.error("Could not start the tracker: {}!", (Object)ioe.getMessage());
                Tracker.this.stop();
            }
        }
    }

    private static class TorrentRemoveTimer
    extends TimerTask {
        private Tracker tracker;
        private Torrent torrent;

        TorrentRemoveTimer(Tracker tracker, Torrent torrent) {
            this.tracker = tracker;
            this.torrent = torrent;
        }

        @Override
        public void run() {
            this.tracker.remove(this.torrent);
        }
    }
}

