/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.cli;

import com.turn.ttorrent.common.Torrent;
import jargs.gnu.CmdLineParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TorrentMain {
    private static final Logger logger = LoggerFactory.getLogger(TorrentMain.class);

    private static void usage(PrintStream s) {
        TorrentMain.usage(s, null);
    }

    private static void usage(PrintStream s, String msg) {
        if (msg != null) {
            s.println(msg);
            s.println();
        }
        s.println("usage: Torrent [options] [file|directory]");
        s.println();
        s.println("Available options:");
        s.println("  -h,--help             Show this help and exit.");
        s.println("  -t,--torrent FILE     Use FILE to read/write torrent file.");
        s.println();
        s.println("  -c,--create           Create a new torrent file using the given announce URL and data.");
        s.println("  -a,--announce         Tracker URL (can be repeated).");
        s.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        void var10_15;
        String filenameValue;
        BasicConfigurator.configure((Appender)new ConsoleAppender((Layout)new PatternLayout("%-5p: %m%n")));
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option help = parser.addBooleanOption('h', "help");
        CmdLineParser.Option filename = parser.addStringOption('t', "torrent");
        CmdLineParser.Option create = parser.addBooleanOption('c', "create");
        CmdLineParser.Option announce = parser.addStringOption('a', "announce");
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.OptionException oe) {
            System.err.println(oe.getMessage());
            TorrentMain.usage(System.err);
            System.exit(1);
        }
        if (Boolean.TRUE.equals((Boolean)parser.getOptionValue(help))) {
            TorrentMain.usage(System.out);
            System.exit(0);
        }
        if ((filenameValue = (String)parser.getOptionValue(filename)) == null) {
            TorrentMain.usage(System.err, "Torrent file must be provided!");
            System.exit(1);
        }
        Boolean createFlag = (Boolean)parser.getOptionValue(create);
        String announceURL = (String)parser.getOptionValue(announce);
        String[] otherArgs = parser.getRemainingArgs();
        if (Boolean.TRUE.equals(createFlag) && (otherArgs.length != 1 || announceURL == null)) {
            TorrentMain.usage(System.err, "Announce URL and a file or directory must be provided to create a torrent file!");
            System.exit(1);
        }
        OutputStream outputStream = null;
        try {
            if (Boolean.TRUE.equals(createFlag)) {
                void var10_14;
                if (filenameValue != null) {
                    FileOutputStream fileOutputStream = new FileOutputStream(filenameValue);
                } else {
                    PrintStream printStream = System.out;
                }
                URI announceURI = new URI(announceURL);
                File source = new File(otherArgs[0]);
                if (!source.exists() || !source.canRead()) {
                    throw new IllegalArgumentException("Cannot access source file or directory " + source.getName());
                }
                String creator = String.format("%s (ttorrent)", System.getProperty("user.name"));
                Torrent torrent = null;
                if (source.isDirectory()) {
                    Object[] files = source.listFiles();
                    Arrays.sort(files);
                    torrent = Torrent.create(source, Arrays.asList(files), announceURI, creator);
                } else {
                    torrent = Torrent.create(source, announceURI, creator);
                }
                torrent.save((OutputStream)var10_14);
            } else {
                Torrent.load(new File(filenameValue), true);
            }
            if (var10_15 == System.out) return;
        }
        catch (Exception e) {
            logger.error("{}", (Object)e.getMessage(), (Object)e);
            System.exit(2);
            return;
        }
        finally {
            if (outputStream != System.out) {
                IOUtils.closeQuietly(outputStream);
            }
        }
        IOUtils.closeQuietly((OutputStream)var10_15);
        return;
    }
}

