/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit3d.core.zip4j;

import com.thankjava.toolkit3d.bean.zip4j.ZipLevel;
import com.thankjava.toolkit3d.bean.zip4j.ZipType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;

public class Zip4jUtil {
    private static final String SUFFIX = ".zip";

    public static boolean unzip(String zipFilePath, String folderPath, String ... pwd) {
        ZipFile zipFile;
        try {
            zipFile = new ZipFile(new File(zipFilePath));
            if (!zipFile.isValidZipFile()) {
                new ZipException("Invalid archive").printStackTrace();
                return false;
            }
            if (zipFile.isEncrypted()) {
                if (pwd == null || pwd.length == 0) {
                    new ZipException("The password is required to access the io").printStackTrace();
                    return false;
                }
                zipFile.setPassword(pwd[0]);
            }
        }
        catch (ZipException e) {
            e.printStackTrace();
            return false;
        }
        try {
            File filePath = new File(folderPath);
            if (filePath.isDirectory() && !filePath.exists()) {
                filePath.mkdirs();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        try {
            zipFile.extractAll(folderPath);
        }
        catch (ZipException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean zip(String srcPath, String zipFilePath, ZipType zipType, ZipLevel zipLevel, String ... pwd) {
        File srcFile = new File(srcPath);
        boolean isSrcDirectory = true;
        if (srcFile.isDirectory()) {
            if (!srcFile.exists()) {
                new ZipException("Target resource does not exist").printStackTrace();
                return false;
            }
        } else {
            isSrcDirectory = false;
        }
        File file = new File(zipFilePath);
        String zipPath = null;
        if (!file.isDirectory()) {
            File temp = file.getParentFile();
            if (!temp.exists()) {
                if (!temp.mkdirs()) {
                    new ZipException("Automatically creates extraction path failure").printStackTrace();
                    return false;
                }
                zipPath = file.getPath();
            } else {
                zipPath = file.getPath();
            }
        } else {
            if (!file.exists() && !file.mkdirs()) {
                new ZipException("Automatically creates extraction path failure").printStackTrace();
                return false;
            }
            zipPath = file.getPath() + File.separator + srcFile.getName() + SUFFIX;
        }
        ZipParameters zipParameters = new ZipParameters();
        zipParameters.setCompressionMethod(zipType.getCode());
        zipParameters.setCompressionLevel(zipLevel.getCode());
        if (pwd != null && pwd.length > 0) {
            zipParameters.setEncryptFiles(true);
            zipParameters.setEncryptionMethod(0);
            zipParameters.setPassword(pwd[0]);
        } else {
            zipParameters.setEncryptFiles(false);
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zipPath);
            if (!isSrcDirectory) {
                zipFile.addFile(srcFile, zipParameters);
                return true;
            }
            File[] files = srcFile.listFiles();
            if (files != null && files.length != 0) {
                ArrayList fileList = new ArrayList();
                Collections.addAll(fileList, files);
                zipFile.addFiles(fileList, zipParameters);
                return true;
            }
            new ZipException("Invalid resource specified").printStackTrace();
            return false;
        }
        catch (ZipException e) {
            e.printStackTrace();
            return false;
        }
    }
}

