/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit3d.core.xml.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.util.Map;
import java.util.WeakHashMap;

public class XMLBeanUtil {
    private static final String ENCODING = "utf-8";
    private static XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver("utf-8"));
    private static final Map<Class<?>, XStream> xStreamInstance = new WeakHashMap();

    public static <T> T xml2Bean(String xmlRoot, String xml, Class<T> clazz, boolean isIgnoreUnknownEles) {
        XStream xStream = xStreamInstance.get(clazz);
        if (xStream == null) {
            xStream = new XStream((HierarchicalStreamDriver)new DomDriver(ENCODING));
            xStream.alias(xmlRoot, clazz);
            if (isIgnoreUnknownEles) {
                xStream.ignoreUnknownElements();
            }
        }
        return (T)xStream.fromXML(xml);
    }

    public static <T> T xml2Bean(Map<String, Class<?>> classMap, String xmlStr, Class<T> clazz, boolean isIgnoreUnknownEles) {
        XStream xStream = xStreamInstance.get(clazz);
        if (xStream == null) {
            xStream = new XStream((HierarchicalStreamDriver)new DomDriver(ENCODING));
            for (String key : classMap.keySet()) {
                xStream.alias(key, classMap.get(key));
            }
            if (isIgnoreUnknownEles) {
                xStream.ignoreUnknownElements();
            }
        }
        return (T)xStream.fromXML(xmlStr);
    }

    public static String bean2Xml(Object obj) {
        return xStream.toXML(obj);
    }
}

