/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit3d.core.mail.javax;

import com.thankjava.toolkit3d.bean.mail.MailContent;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public final class MailUtil {
    private MailUtil() {
    }

    public static void sendMail(MailContent mailContent) throws MessagingException {
        Properties pro = mailContent.getProperties();
        MailUtil mailUtil = new MailUtil();
        mailUtil.getClass();
        AuthEntity authEntity = mailUtil.new AuthEntity(mailContent.getAuthUsername(), mailContent.getAuthPassword());
        Session sendMailSession = Session.getDefaultInstance((Properties)pro, (Authenticator)authEntity);
        MimeMessage mailMessage = new MimeMessage(sendMailSession);
        InternetAddress from = new InternetAddress(mailContent.getFromAddress());
        mailMessage.setFrom((Address)from);
        InternetAddress to = new InternetAddress(mailContent.getToAddress());
        mailMessage.setRecipient(Message.RecipientType.TO, (Address)to);
        mailMessage.setSubject(mailContent.getSubject());
        mailMessage.setSentDate(new Date());
        MimeMultipart mainPart = new MimeMultipart();
        MimeBodyPart html = new MimeBodyPart();
        html.setContent((Object)mailContent.getContent(), "text/html; charset=utf-8");
        mainPart.addBodyPart((BodyPart)html);
        mailMessage.setContent((Multipart)mainPart);
        Transport.send((Message)mailMessage);
    }

    public static void sendMail(MailContent mailContent, File attachment) throws MessagingException, UnsupportedEncodingException {
        Properties pro = mailContent.getProperties();
        MailUtil mailUtil = new MailUtil();
        mailUtil.getClass();
        AuthEntity authEntity = mailUtil.new AuthEntity(mailContent.getAuthUsername(), mailContent.getAuthPassword());
        Session sendMailSession = Session.getDefaultInstance((Properties)pro, (Authenticator)authEntity);
        MimeMessage mailMessage = new MimeMessage(sendMailSession);
        InternetAddress from = new InternetAddress(mailContent.getFromAddress());
        mailMessage.setFrom((Address)from);
        InternetAddress to = new InternetAddress(mailContent.getToAddress());
        mailMessage.setRecipient(Message.RecipientType.TO, (Address)to);
        mailMessage.setSubject(mailContent.getSubject());
        mailMessage.setSentDate(new Date());
        MimeMultipart mainPart = new MimeMultipart();
        MimeBodyPart html = new MimeBodyPart();
        html.setContent((Object)mailContent.getContent(), "text/html; charset=utf-8");
        if (attachment != null) {
            MimeBodyPart attachmentBodyPart = new MimeBodyPart();
            FileDataSource source = new FileDataSource(attachment);
            attachmentBodyPart.setDataHandler(new DataHandler((DataSource)source));
            attachmentBodyPart.setFileName(MimeUtility.encodeWord((String)attachment.getName()));
            mainPart.addBodyPart((BodyPart)attachmentBodyPart);
        }
        mainPart.addBodyPart((BodyPart)html);
        mailMessage.setContent((Multipart)mainPart);
        Transport.send((Message)mailMessage);
    }

    class AuthEntity
    extends Authenticator {
        String userName;
        String password;

        protected AuthEntity(String username, String password) {
            this.userName = username;
            this.password = password;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.userName, this.password);
        }
    }
}

