/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit3d.core.http.httpclient.async.core;

import com.thankjava.toolkit3d.bean.http.AsyncRequest;
import com.thankjava.toolkit3d.bean.http.Headers;
import com.thankjava.toolkit3d.bean.http.HttpMethod;
import com.thankjava.toolkit3d.bean.http.Parameters;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class RequestBuilder {
    public static HttpRequestBase builderRequest(AsyncRequest asyncRequest) {
        HttpRequestBase request = null;
        if (HttpMethod.post.equals((Object)asyncRequest.getHttpMethod())) {
            request = RequestBuilder.addParamsPost(asyncRequest);
        } else if (HttpMethod.get.equals((Object)asyncRequest.getHttpMethod())) {
            request = RequestBuilder.addParamsGet(asyncRequest);
        }
        return request;
    }

    private static HttpRequestBase addParamsPost(AsyncRequest asyncRequest) {
        Parameters parameter;
        HttpPost post = new HttpPost(asyncRequest.getUrl());
        Headers header = asyncRequest.getHeader();
        if (header != null) {
            post.setHeaders(header.toHeaderArray());
        }
        if ((parameter = asyncRequest.getParameter()) != null) {
            if (parameter.getNameValuePair() != null) {
                try {
                    post.setEntity((HttpEntity)new UrlEncodedFormEntity(parameter.getNameValuePair(), asyncRequest.getReqCharset().charset));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            } else if (parameter.getText() != null) {
                post.setEntity((HttpEntity)new StringEntity(parameter.getText(), ContentType.create((String)(parameter.getContentType() == null ? ContentType.DEFAULT_TEXT.getMimeType() : parameter.getContentType()), (Charset)Charset.forName(parameter.getContentEncoding() == null ? asyncRequest.getReqCharset().charset : parameter.getContentEncoding()))));
            } else if (parameter.getByteData() != null) {
                EntityBuilder entityBuilder = EntityBuilder.create();
                entityBuilder.setBinary(parameter.getByteData());
                if (parameter.getContentEncoding() != null) {
                    entityBuilder.setContentEncoding(parameter.getContentEncoding());
                }
                entityBuilder.setContentType(ContentType.create((String)(parameter.getContentType() == null ? ContentType.DEFAULT_TEXT.getMimeType() : parameter.getContentType()), (Charset)Charset.forName(parameter.getContentEncoding() == null ? asyncRequest.getReqCharset().charset : parameter.getContentEncoding())));
                post.setEntity(entityBuilder.build());
            } else if (parameter.getFile() != null) {
                EntityBuilder entityBuilder = EntityBuilder.create();
                entityBuilder.setFile(parameter.getFile());
                if (parameter.getContentEncoding() != null) {
                    entityBuilder.setContentEncoding(parameter.getContentEncoding());
                }
                entityBuilder.setContentType(ContentType.create((String)(parameter.getContentType() == null ? ContentType.DEFAULT_TEXT.getMimeType() : parameter.getContentType()), (Charset)Charset.forName(parameter.getContentEncoding() == null ? asyncRequest.getReqCharset().charset : parameter.getContentEncoding())));
                post.setEntity(entityBuilder.build());
            }
        }
        return post;
    }

    private static HttpRequestBase addParamsGet(AsyncRequest asyncRequest) {
        Headers header;
        HttpGet get = new HttpGet(asyncRequest.getUrl());
        Parameters parameter = asyncRequest.getParameter();
        if (parameter != null && parameter.getNameValuePair() != null) {
            try {
                get.setURI(new URIBuilder(get.getURI()).addParameters(parameter.getNameValuePair()).build());
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        if ((header = asyncRequest.getHeader()) != null) {
            get.setHeaders(header.toHeaderArray());
        }
        return get;
    }
}

