/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit3d.core.http.httpclient.async;

import com.thankjava.toolkit3d.bean.http.CookieCheckLevel;
import com.thankjava.toolkit3d.core.http.httpclient.async.AsyncHttpClient;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;

public class AsyncHttpClientBuilder {
    private HttpAsyncClientBuilder httpAsyncClientBuilder = HttpAsyncClients.custom();
    private RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();

    public static AsyncHttpClient createDefault() {
        return new AsyncHttpClient(HttpAsyncClients.createDefault());
    }

    public AsyncHttpClientBuilder setWithoutSSLCheck() {
        SSLContext sslContext = null;
        try {
            sslContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)new org.apache.http.conn.ssl.TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) {
                    return true;
                }
            }).build();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        this.httpAsyncClientBuilder.setSSLContext(sslContext);
        return this;
    }

    public AsyncHttpClientBuilder setCookiePolicyLevel(CookieCheckLevel cookiePolicyLevel) {
        this.requestConfigBuilder.setCookieSpec(cookiePolicyLevel.code);
        return this;
    }

    public AsyncHttpClientBuilder setCloseWarnLogger() {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.defaultlog", "error");
        return this;
    }

    public AsyncHttpClientBuilder setTimeout(int timeout) {
        this.requestConfigBuilder.setConnectTimeout(timeout);
        this.requestConfigBuilder.setSocketTimeout(timeout);
        this.requestConfigBuilder.setConnectionRequestTimeout(timeout);
        return this;
    }

    public AsyncHttpClient create() {
        this.httpAsyncClientBuilder.setDefaultRequestConfig(this.requestConfigBuilder.build());
        return new AsyncHttpClient(this.httpAsyncClientBuilder.build());
    }
}

