/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit3d.core.http.httpclient.async;

import com.thankjava.toolkit3d.bean.http.AsyncRequest;
import com.thankjava.toolkit3d.bean.http.AsyncResponse;
import com.thankjava.toolkit3d.bean.http.AsyncResponseCallback;
import com.thankjava.toolkit3d.bean.http.Cookies;
import com.thankjava.toolkit3d.core.http.httpclient.async.core.DoRequest;
import java.io.IOException;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;

public class AsyncHttpClient {
    private static DoRequest doRequest;
    private static CloseableHttpAsyncClient closeableHttpAsyncClient;

    AsyncHttpClient(CloseableHttpAsyncClient closeableHttpAsyncClient) {
        AsyncHttpClient.closeableHttpAsyncClient = closeableHttpAsyncClient;
        closeableHttpAsyncClient.start();
        doRequest = DoRequest.getInterface(closeableHttpAsyncClient);
    }

    public AsyncResponse syncRequestWithSession(AsyncRequest asyncRequest) {
        return doRequest.doRequest(asyncRequest, true, null);
    }

    public AsyncResponse syncRequestWithoutSession(AsyncRequest asyncRequest) {
        return doRequest.doRequest(asyncRequest, false, null);
    }

    public void asyncRequestWithSession(AsyncRequest asyncRequest, AsyncResponseCallback asyncResponseCallback) {
        doRequest.doRequest(asyncRequest, true, asyncResponseCallback);
    }

    public void asyncRequestWithoutSession(AsyncRequest asyncRequest, AsyncResponseCallback asyncResponseCallback) {
        doRequest.doRequest(asyncRequest, false, asyncResponseCallback);
    }

    public Cookies getAllCookiesFromClientContext() {
        return new Cookies(DoRequest.getSyncCookieStore().getCookies());
    }

    public Cookie getCookieFromClientContext(String cookieName) {
        return this.getAllCookiesFromClientContext().getCookie(cookieName);
    }

    public void shutdown() {
        try {
            closeableHttpAsyncClient.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

