/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit3d.core.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.thankjava.toolkit.core.reflect.BeanCopierUtil;
import java.util.Map;

public class FastJson {
    public static <T> T toObject(String json, Class<T> clazz) {
        if (json == null || json.trim().length() == 0) {
            return null;
        }
        Object t = null;
        try {
            t = JSON.parseObject((String)json, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (T)t;
    }

    public static <T> T toObject(JSONObject jsonObject, Class<T> clazz) {
        if (jsonObject == null) {
            return null;
        }
        return (T)JSONObject.toJavaObject((JSON)jsonObject, clazz);
    }

    public static <T> T appendObject(String json, T t) {
        Class<?> clazz = t.getClass();
        Object tNew = FastJson.toObject(json, clazz);
        BeanCopierUtil.append(tNew, t);
        return (T)tNew;
    }

    public static JSONObject toJSONObject(Object object) {
        return (JSONObject)JSONObject.toJSON((Object)object);
    }

    public static JSONObject toJSONObject(String json) {
        return JSONObject.parseObject((String)json);
    }

    public static JSONArray toJSONArray(Object object) {
        return (JSONArray)JSONArray.toJSON((Object)object);
    }

    public static JSONArray toJSONArray(String json) {
        return JSONArray.parseArray((String)json);
    }

    public static Map<String, Object> toMap(Object object) {
        if (object == null) {
            return null;
        }
        return FastJson.toMap(FastJson.toJSONString(object));
    }

    public static Map<String, Object> toMap(String json) {
        return (Map)JSON.parse((String)json);
    }

    public static String toJSONString(Object object) {
        if (object == null) {
            return null;
        }
        return JSONObject.toJSONString((Object)object);
    }

    public static String toFormatJSONString(Object object) {
        Object obj = object instanceof String ? JSONObject.parse((String)((String)object)) : JSONObject.toJSON((Object)object);
        return JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
    }
}

