/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit3d.core.excel.poi.impl;

import com.thankjava.toolkit.bean.utils.TimeType;
import com.thankjava.toolkit.core.utils.TimeUtil;
import com.thankjava.toolkit3d.bean.excel.poi.DefaultNumberType;
import com.thankjava.toolkit3d.bean.excel.poi.FormatCellValueType;
import com.thankjava.toolkit3d.core.excel.poi.POIReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

class POIReaderImpl
implements POIReader {
    private boolean isSkipFirstRow = false;
    private int sheetIndex = 0;
    private String defaultValue = "";
    private int maxRowNumber = -1;
    private int maxColumnNumber = -1;
    private boolean autoTrim = false;
    private Map<String, FormatCellValueType> formatConfig = new HashMap<String, FormatCellValueType>();
    private TimeType defaultTimeFormatType = TimeType.DEFAULT;
    private boolean ignoreDataFormatError = false;
    private DefaultNumberType defaultNumberType = DefaultNumberType.DOUBLE;
    Workbook workbook;
    Sheet sheet;

    POIReaderImpl(String filePath) {
        try {
            this.workbook = new HSSFWorkbook((InputStream)new FileInputStream(filePath));
        }
        catch (IOException | OfficeXmlFileException e) {
            if (e instanceof OfficeXmlFileException) {
                try {
                    this.workbook = new XSSFWorkbook((InputStream)new FileInputStream(filePath));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            e.printStackTrace();
        }
    }

    private FormatCellValueType getCellValueType(int rowIndex, int columnIndex, Cell cell) {
        FormatCellValueType type = this.formatConfig.get(rowIndex + ";" + columnIndex);
        if (type == null) {
            type = this.formatConfig.get("*;" + columnIndex);
        }
        if (type == null) {
            type = this.formatConfig.get(rowIndex + ";*");
        }
        return type;
    }

    private String getCellValue(int rowIndex, int columnIndex, Cell cell) {
        String value;
        block23: {
            if (cell == null) {
                return this.defaultValue;
            }
            value = this.defaultValue;
            FormatCellValueType formatCellValueType = this.getCellValueType(rowIndex, columnIndex, cell);
            if (formatCellValueType == null) {
                block1 : switch (cell.getCellTypeEnum()) {
                    case BOOLEAN: {
                        return String.valueOf(cell.getBooleanCellValue());
                    }
                    case NUMERIC: {
                        switch (this.defaultNumberType) {
                            case DOUBLE: {
                                value = String.valueOf(cell.getNumericCellValue());
                                break block1;
                            }
                            case INTEGER: {
                                value = String.valueOf((int)cell.getNumericCellValue());
                            }
                        }
                        break;
                    }
                    case FORMULA: {
                        value = cell.getCellFormula();
                        break;
                    }
                    case BLANK: {
                        value = this.defaultValue;
                        break;
                    }
                    case ERROR: {
                        break;
                    }
                    default: {
                        value = cell.getStringCellValue();
                        if (value != null && this.autoTrim) {
                            value = value.trim();
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else {
                try {
                    switch (formatCellValueType) {
                        case DATE: {
                            value = TimeUtil.formatDate((TimeType)this.defaultTimeFormatType, (Date)cell.getDateCellValue());
                            break;
                        }
                        case NUMBER_DOUBLE: {
                            value = String.valueOf(cell.getNumericCellValue());
                            break;
                        }
                        case NUMBER_INTEGER: {
                            value = String.valueOf((long)cell.getNumericCellValue());
                            break;
                        }
                        case STRING: {
                            value = cell.getStringCellValue();
                            if (value == null || !this.autoTrim) break;
                            value = value.trim();
                        }
                    }
                }
                catch (Throwable e) {
                    if (this.ignoreDataFormatError) break block23;
                    e.printStackTrace();
                }
            }
        }
        return value;
    }

    @Override
    public List<String[]> readAll() {
        ArrayList<String[]> data = new ArrayList<String[]>();
        this.sheet = this.workbook.getSheetAt(this.sheetIndex);
        int maxRowNumber = this.maxRowNumber < 0 ? this.sheet.getLastRowNum() : this.maxRowNumber;
        String[] columns = null;
        for (int rowIndex = 0; rowIndex <= maxRowNumber; ++rowIndex) {
            if (this.isSkipFirstRow && rowIndex == 0) continue;
            Row row = this.sheet.getRow(rowIndex);
            int maxColumnNumber = this.maxColumnNumber < 0 ? row.getLastCellNum() : this.maxColumnNumber;
            columns = new String[maxColumnNumber + 1];
            for (int columnIndex = 0; columnIndex <= maxColumnNumber; ++columnIndex) {
                if (row == null) {
                    columns[columnIndex] = this.defaultValue;
                    continue;
                }
                Cell cell = row.getCell(columnIndex);
                columns[columnIndex] = this.getCellValue(rowIndex, columnIndex, cell);
            }
            data.add(columns);
        }
        return data;
    }

    @Override
    public String getPositionCellValue(int rowNumber, int columnNumber) {
        if (rowNumber < 1 || columnNumber < 1) {
            return this.defaultValue;
        }
        Row row = this.sheet.getRow(rowNumber - 1);
        if (row == null) {
            return this.defaultValue;
        }
        Cell cell = row.getCell(columnNumber - 1);
        if (cell == null) {
            return this.defaultValue;
        }
        return this.getCellValue(rowNumber - 1, columnNumber - 1, cell);
    }
}

