/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit3d.core.excel.poi;

import com.thankjava.toolkit.bean.utils.TimeType;
import com.thankjava.toolkit.core.reflect.ReflectUtil;
import com.thankjava.toolkit3d.bean.excel.poi.DefaultNumberType;
import com.thankjava.toolkit3d.bean.excel.poi.FormatCellValueType;
import com.thankjava.toolkit3d.core.excel.poi.POIReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class POIExcelBuilder {
    private boolean isSkipFirstRow = false;
    private int sheetIndex = 0;
    private String defaultValue = "";
    private int maxRowNumber = -1;
    private int maxColumnNumber = -1;
    private boolean autoTrim = false;
    private Map<String, FormatCellValueType> formatConfig = new HashMap<String, FormatCellValueType>();
    private TimeType defaultTimeFormatType = TimeType.DEFAULT;
    private boolean ignoreDataFormatError = false;
    private DefaultNumberType defaultNumberType = DefaultNumberType.DOUBLE;
    private String filePath;

    public POIExcelBuilder(String filePath) {
        this.filePath = filePath;
    }

    public POIExcelBuilder setSkipFirstRow() {
        this.isSkipFirstRow = true;
        return this;
    }

    public POIExcelBuilder setReadSheetIndex(int index) {
        if (index - 1 >= 0) {
            this.sheetIndex = index - 1;
        }
        return this;
    }

    public POIExcelBuilder setDefaultValue(String value) {
        this.defaultValue = value;
        return this;
    }

    public POIExcelBuilder setMaxRowNumber(int number) {
        if (number >= 1) {
            this.maxRowNumber = number - 1;
        }
        return this;
    }

    public POIExcelBuilder setMaxColumnNumber(int number) {
        if (number >= 1) {
            this.maxColumnNumber = number - 1;
        }
        return this;
    }

    public POIExcelBuilder setValueAutoTrim() {
        this.autoTrim = true;
        return this;
    }

    public POIExcelBuilder setPositionFormatCellValueType(int rowNumber, int columnNumber, FormatCellValueType cellValueType) {
        if (columnNumber >= 1 && rowNumber >= 1) {
            this.formatConfig.put(rowNumber - 1 + ";" + (columnNumber - 1), cellValueType);
        }
        return this;
    }

    public POIExcelBuilder setRowFormatCellValueType(int rowNumber, FormatCellValueType cellValueType) {
        if (rowNumber >= 1) {
            this.formatConfig.put(rowNumber - 1 + ";*", cellValueType);
        }
        return this;
    }

    public POIExcelBuilder setIgnoreDataFormatError() {
        this.ignoreDataFormatError = true;
        return this;
    }

    public POIExcelBuilder setColumnFormatCellValueType(int columnNumber, FormatCellValueType cellValueType) {
        if (columnNumber >= 1) {
            this.formatConfig.put("*;" + (columnNumber - 1), cellValueType);
        }
        return this;
    }

    public POIExcelBuilder setDefaultTimeFormatType(TimeType timeType) {
        if (timeType != null) {
            this.defaultTimeFormatType = timeType;
        }
        return this;
    }

    public POIReader buildReader() {
        try {
            Class<?> clazz = Class.forName("com.thankjava.toolkit3d.core.excel.poi.impl.POIReaderImpl");
            Constructor<?> constructor = clazz.getDeclaredConstructor(String.class);
            constructor.setAccessible(true);
            Object poiReader = constructor.newInstance(this.filePath);
            ReflectUtil.setFieldVal(poiReader, (String)"sheetIndex", (Object)this.sheetIndex);
            ReflectUtil.setFieldVal(poiReader, (String)"isSkipFirstRow", (Object)this.isSkipFirstRow);
            ReflectUtil.setFieldVal(poiReader, (String)"defaultValue", (Object)this.defaultValue);
            ReflectUtil.setFieldVal(poiReader, (String)"maxRowNumber", (Object)this.maxRowNumber);
            ReflectUtil.setFieldVal(poiReader, (String)"maxColumnNumber", (Object)this.maxColumnNumber);
            ReflectUtil.setFieldVal(poiReader, (String)"autoTrim", (Object)this.autoTrim);
            ReflectUtil.setFieldVal(poiReader, (String)"formatConfig", this.formatConfig);
            ReflectUtil.setFieldVal(poiReader, (String)"defaultTimeFormatType", (Object)this.defaultTimeFormatType);
            ReflectUtil.setFieldVal(poiReader, (String)"ignoreDataFormatError", (Object)this.ignoreDataFormatError);
            ReflectUtil.setFieldVal(poiReader, (String)"defaultNumberType", (Object)((Object)this.defaultNumberType));
            return (POIReader)poiReader;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }
}

