/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit3d.core.encrypit;

import com.thankjava.toolkit.bean.encrypit.RSAEncryptAlgorithm;
import com.thankjava.toolkit.bean.encrypit.RSAKey;
import com.thankjava.toolkit.bean.encrypit.RSASignAlgorithm;
import com.thankjava.toolkit.core.encrypit.RSA;
import com.thankjava.toolkit3d.bean.encrypit.RSAKeyString;
import com.thankjava.toolkit3d.core.encrypit.Base64Util;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class RSAWithBase64 {
    private static final String algorithm = "RSA";
    private static final RSAEncryptAlgorithm defaultEncryptAlgorithm = RSAEncryptAlgorithm.RSA_ECB_PKCS1Padding;
    private static final RSASignAlgorithm defaultSignAlgorithm = RSASignAlgorithm.SHA1withRSA;

    public static RSAKeyString keyGen(int keySize) {
        try {
            RSAKey keys = RSA.keyGen((int)keySize);
            return new RSAKeyString(Base64Util.encode2String(keys.getPublicKey().getEncoded()), Base64Util.encode2String(keys.getPrivateKey().getEncoded()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static PrivateKey decryptPrivateKey(String privateKeyStr) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64Util.decode(privateKeyStr));
            return keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static PublicKey decryptPublicKey(String publicKeyStr) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64Util.decode(publicKeyStr));
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String encrypt(String content, String pubKey, RSAEncryptAlgorithm ... rsaEncryptAlgorithm) {
        if (rsaEncryptAlgorithm != null && rsaEncryptAlgorithm.length > 0) {
            return Base64Util.encode2String(RSA.encrypt((byte[])content.getBytes(), (PublicKey)RSAWithBase64.decryptPublicKey(pubKey), (RSAEncryptAlgorithm)rsaEncryptAlgorithm[0]));
        }
        return Base64Util.encode2String(RSA.encrypt((byte[])content.getBytes(), (PublicKey)RSAWithBase64.decryptPublicKey(pubKey), (RSAEncryptAlgorithm)defaultEncryptAlgorithm));
    }

    public static String decrypt(String base64Cipher, String priKey, RSAEncryptAlgorithm ... rsaEncryptAlgorithm) {
        if (rsaEncryptAlgorithm != null && rsaEncryptAlgorithm.length > 0) {
            return new String(RSA.decrypt((byte[])Base64Util.decode(base64Cipher), (PrivateKey)RSAWithBase64.decryptPrivateKey(priKey), (RSAEncryptAlgorithm)rsaEncryptAlgorithm[0]));
        }
        return new String(RSA.decrypt((byte[])Base64Util.decode(base64Cipher), (PrivateKey)RSAWithBase64.decryptPrivateKey(priKey), (RSAEncryptAlgorithm)defaultEncryptAlgorithm));
    }

    public static String sign(String content, String priKey, RSASignAlgorithm ... rsaSignAlgorithm) {
        if (rsaSignAlgorithm != null && rsaSignAlgorithm.length > 0) {
            return Base64Util.encode2String(RSA.sign((byte[])content.getBytes(), (PrivateKey)RSAWithBase64.decryptPrivateKey(priKey), (RSASignAlgorithm)rsaSignAlgorithm[0]));
        }
        return Base64Util.encode2String(RSA.sign((byte[])content.getBytes(), (PrivateKey)RSAWithBase64.decryptPrivateKey(priKey), (RSASignAlgorithm)defaultSignAlgorithm));
    }

    public static boolean verify(String content, String base64Cipher, String pubKey, RSASignAlgorithm ... rsaSignAlgorithm) {
        if (rsaSignAlgorithm != null && rsaSignAlgorithm.length > 0) {
            return RSA.verify((byte[])content.getBytes(), (byte[])Base64Util.decode(base64Cipher), (PublicKey)RSAWithBase64.decryptPublicKey(pubKey), (RSASignAlgorithm)rsaSignAlgorithm[0]);
        }
        return RSA.verify((byte[])content.getBytes(), (byte[])Base64Util.decode(base64Cipher), (PublicKey)RSAWithBase64.decryptPublicKey(pubKey), (RSASignAlgorithm)defaultSignAlgorithm);
    }
}

