/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit3d.core.db.redis.impl;

import com.thankjava.toolkit.core.utils.SourceLoaderUtil;
import com.thankjava.toolkit3d.core.db.redis.RedisManager;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Pipeline;

class RedisManagerImpl
implements RedisManager {
    private static JedisPool jedisPool = null;
    private static final String SUCCESS_CODE_STR = "OK";
    private static RedisManager manager = null;
    private static int DEFAULT_DB_INDEX = 0;

    private RedisManagerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RedisManager init(String configPath) {
        if (manager != null) {
            return manager;
        }
        manager = new RedisManagerImpl();
        Reader reader = null;
        if (configPath == null || configPath.trim().length() == 0) {
            reader = SourceLoaderUtil.getResourceAsReader((String)"redis.properties");
        } else {
            try {
                reader = new FileReader(configPath);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        try {
            String pwd;
            int dbIndex;
            Properties props = new Properties();
            props.load(reader);
            JedisPoolConfig readConfig = new JedisPoolConfig();
            readConfig.setMaxTotal(Integer.valueOf(props.getProperty("redis.pool.maxTotal")).intValue());
            readConfig.setMaxIdle(Integer.valueOf(props.getProperty("redis.pool.maxIdle")).intValue());
            readConfig.setMaxWaitMillis(Long.valueOf(props.getProperty("redis.pool.maxWaitMillis")).longValue());
            readConfig.setTestOnBorrow(Boolean.valueOf(props.getProperty("redis.pool.testOnBorrow")).booleanValue());
            readConfig.setTestOnReturn(Boolean.valueOf(props.getProperty("redis.pool.testOnReturn")).booleanValue());
            String dbIndexStr = props.getProperty("redis.db.index");
            if (dbIndexStr != null && dbIndexStr.trim().length() > 0 && (dbIndex = Integer.valueOf(props.getProperty("redis.db.index")).intValue()) >= 0) {
                DEFAULT_DB_INDEX = dbIndex;
            }
            jedisPool = (pwd = props.getProperty("redis.pwd")) == null || pwd.trim().length() == 0 ? new JedisPool((GenericObjectPoolConfig)readConfig, props.getProperty("redis.ip"), Integer.valueOf(props.getProperty("redis.port")).intValue(), Integer.valueOf(props.getProperty("redis.timeout")).intValue(), null, DEFAULT_DB_INDEX, null) : new JedisPool((GenericObjectPoolConfig)readConfig, props.getProperty("redis.ip"), Integer.valueOf(props.getProperty("redis.port")).intValue(), Integer.valueOf(props.getProperty("redis.timeout")).intValue(), pwd, DEFAULT_DB_INDEX, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return manager;
    }

    private static Jedis getJedis() {
        return jedisPool.getResource();
    }

    private static void returnJedis(Jedis jedis) {
        if (jedis != null) {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean set(String key, String value) {
        Jedis jedis = null;
        try {
            jedis = RedisManagerImpl.getJedis();
            boolean bl = jedis.set(key, value).equals(SUCCESS_CODE_STR);
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            RedisManagerImpl.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String key) {
        Jedis jedis = null;
        try {
            jedis = RedisManagerImpl.getJedis();
            String string = jedis.get(key);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            RedisManagerImpl.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String key) {
        Jedis jedis = null;
        try {
            jedis = RedisManagerImpl.getJedis();
            boolean bl = jedis.exists(key);
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            RedisManagerImpl.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean expire(String key, int expirationTime) {
        Jedis jedis = null;
        try {
            jedis = RedisManagerImpl.getJedis();
            boolean bl = jedis.expire(key, expirationTime) > 0L;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            RedisManagerImpl.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sadd(String key, String ... setValue) {
        Jedis jedis = null;
        try {
            jedis = RedisManagerImpl.getJedis();
            boolean bl = jedis.sadd(key, setValue) > 0L;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            RedisManagerImpl.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hset(String key, String hashKey, String hashValue) {
        Jedis jedis = null;
        try {
            jedis = RedisManagerImpl.getJedis();
            boolean bl = jedis.hset(key, hashKey, hashValue) > 0L;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            RedisManagerImpl.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hmset(String key, HashMap<String, String> hash) {
        Jedis jedis = null;
        try {
            jedis = RedisManagerImpl.getJedis();
            boolean bl = SUCCESS_CODE_STR.equals(jedis.hmset(key, hash));
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            RedisManagerImpl.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean del(String key) {
        Jedis jedis = null;
        try {
            jedis = RedisManagerImpl.getJedis();
            boolean bl = jedis.del(key) > 0L;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            RedisManagerImpl.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lpush(String key, String ... listValue) {
        Jedis jedis = null;
        try {
            jedis = RedisManagerImpl.getJedis();
            long influenceCount = jedis.lpush(key, listValue);
            boolean bl = influenceCount > 0L;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            RedisManagerImpl.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String rpop(String key) {
        Jedis jedis = null;
        try {
            jedis = RedisManagerImpl.getJedis();
            String string = jedis.rpop(key);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            RedisManagerImpl.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> smembers(String key) {
        Jedis jedis = null;
        try {
            jedis = RedisManagerImpl.getJedis();
            Set set = jedis.smembers(key);
            return set;
        }
        catch (Exception e) {
            e.printStackTrace();
            Set<String> set = null;
            return set;
        }
        finally {
            RedisManagerImpl.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> hgetall(String key) {
        Jedis jedis = null;
        try {
            jedis = RedisManagerImpl.getJedis();
            Map map = jedis.hgetAll(key);
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            Map<String, String> map = null;
            return map;
        }
        finally {
            RedisManagerImpl.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> hmget(String key, String ... fields) {
        if (fields == null || fields.length == 0) {
            return null;
        }
        Jedis jedis = null;
        try {
            jedis = RedisManagerImpl.getJedis();
            List list = jedis.hmget(key, fields);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            List<String> list = null;
            return list;
        }
        finally {
            RedisManagerImpl.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> hgetallPipelined(Set<String> keys) {
        if (keys == null || keys.size() == 0) {
            return null;
        }
        Jedis jedis = null;
        Pipeline pipeline = null;
        try {
            jedis = RedisManagerImpl.getJedis();
            pipeline = jedis.pipelined();
            for (String key : keys) {
                pipeline.hgetAll(key);
            }
            List i$ = pipeline.syncAndReturnAll();
            return i$;
        }
        catch (Exception e) {
            e.printStackTrace();
            List<Object> list = null;
            return list;
        }
        finally {
            if (pipeline != null) {
                try {
                    pipeline.close();
                }
                catch (IOException e) {}
            }
            RedisManagerImpl.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hdel(String key, String ... fields) {
        if (fields == null || fields.length == 0) {
            return false;
        }
        Jedis jedis = null;
        try {
            jedis = RedisManagerImpl.getJedis();
            boolean bl = jedis.hdel(key, fields) == 1L;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            RedisManagerImpl.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sismember(String key, String field) {
        Jedis jedis = null;
        try {
            jedis = RedisManagerImpl.getJedis();
            boolean bl = jedis.sismember(key, field);
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            RedisManagerImpl.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long srem(String key, String ... fields) {
        Jedis jedis = null;
        try {
            jedis = RedisManagerImpl.getJedis();
            long l = jedis.srem(key, fields);
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
            long l = 0L;
            return l;
        }
        finally {
            RedisManagerImpl.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incr(String key) {
        Jedis jedis = null;
        try {
            jedis = RedisManagerImpl.getJedis();
            Long l = jedis.incr(key);
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
            Long l = null;
            return l;
        }
        finally {
            RedisManagerImpl.returnJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String hget(String key, String field) {
        Jedis jedis = null;
        try {
            jedis = RedisManagerImpl.getJedis();
            String string = jedis.hget(key, field);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            RedisManagerImpl.returnJedis(jedis);
        }
    }
}

