/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit3d.core.db.mysql.impl;

import com.thankjava.toolkit.core.utils.SourceLoaderUtil;
import com.thankjava.toolkit3d.core.db.mysql.BasicFastToolkit3dMapper;
import com.thankjava.toolkit3d.core.db.mysql.MyBatisManager;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;

class MyBatisManagerImpl
implements MyBatisManager {
    private static SqlSessionFactory sqlSessionFactory;
    private static MyBatisManagerImpl manager;
    private static Map<Object, SqlSession> sessions;
    private static String sourceName;

    private MyBatisManagerImpl() {
    }

    private static MyBatisManager init(String configName) {
        if (manager != null) {
            return manager;
        }
        manager = new MyBatisManagerImpl();
        try {
            sqlSessionFactory = new SqlSessionFactoryBuilder().build(SourceLoaderUtil.getResourceAsReader((String)sourceName));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return manager;
    }

    @Override
    public SqlSession newSqlSession() {
        return sqlSessionFactory.openSession();
    }

    @Override
    public void closeSqlSession(SqlSession session) {
        if (session != null) {
            session.close();
        }
    }

    @Override
    public void commit(SqlSession session) {
        if (session != null) {
            session.commit();
        }
    }

    @Override
    public void commitAndCloseSqlSession(SqlSession session) {
        if (session != null) {
            session.commit();
            session.close();
        }
    }

    @Override
    public <T> T getMapper(Class<? extends BasicFastToolkit3dMapper> t) {
        SqlSession session = this.newSqlSession();
        Object mapper = null;
        try {
            mapper = session.getMapper(t);
            if (mapper == null) {
                session.close();
            } else {
                sessions.put(mapper, session);
            }
        }
        catch (Throwable e) {
            session.close();
        }
        return (T)mapper;
    }

    @Override
    public void closeSqlSession(BasicFastToolkit3dMapper mapper) {
        SqlSession session = sessions.get(mapper);
        if (session != null) {
            session.close();
            sessions.remove(mapper);
            mapper = null;
        }
    }

    @Override
    public void commitAndCloseSqlSession(BasicFastToolkit3dMapper mapper) {
        SqlSession session = sessions.get(mapper);
        if (session != null) {
            session.commit();
            session.close();
            sessions.remove(mapper);
            mapper = null;
        }
    }

    @Override
    public void commit(BasicFastToolkit3dMapper mapper) {
        SqlSession session = sessions.get(mapper);
        if (session != null) {
            session.commit();
        }
    }

    @Override
    public void rollback(BasicFastToolkit3dMapper mapper) {
        SqlSession session = sessions.get(mapper);
        if (session != null) {
            session.rollback();
        }
    }

    static {
        manager = null;
        sessions = new HashMap<Object, SqlSession>();
        sourceName = "mybatis-config.xml";
    }
}

