/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit3d.core.db.mongodb.impl;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.thankjava.toolkit.core.utils.SourceLoaderUtil;
import com.thankjava.toolkit3d.bean.db.PageEntity;
import com.thankjava.toolkit3d.bean.db.Sort;
import com.thankjava.toolkit3d.core.db.mongodb.MongoManager;
import com.thankjava.toolkit3d.core.fastjson.FastJson;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

class MongoManagerImpl
implements MongoManager {
    private static MongoDatabase mongoDatabase = null;
    private static final String OPERATOR_SET = "$set";
    private static final String OBJECT_ID_KEY = "_id";
    private static MongoManager manager = null;

    private MongoManagerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MongoManager init(String configPath) {
        if (manager != null) {
            return manager;
        }
        manager = new MongoManagerImpl();
        Reader reader = null;
        if (configPath == null || configPath.trim().length() == 0) {
            reader = SourceLoaderUtil.getResourceAsReader((String)"mongodb.properties");
        } else {
            try {
                reader = new FileReader(configPath);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        try {
            MongoClient mongoClient = null;
            Properties props = new Properties();
            props.load(reader);
            MongoClientOptions.Builder build = new MongoClientOptions.Builder();
            build.connectionsPerHost(Integer.valueOf(props.getProperty("mongo.pool.connectionsPerHost")).intValue());
            build.threadsAllowedToBlockForConnectionMultiplier(Integer.valueOf(props.getProperty("mongo.pool.threadsAllowedToBlockForConnectionMultiplier")).intValue());
            build.maxWaitTime(Integer.valueOf(props.getProperty("mongo.pool.maxWaitTime")).intValue());
            build.connectTimeout(Integer.valueOf(props.getProperty("mongo.pool.connectTimeout")).intValue());
            MongoClientURI mongoClientURI = new MongoClientURI(props.getProperty("mongo.connString"), build);
            mongoClient = new MongoClient(mongoClientURI);
            mongoDatabase = mongoClient.getDatabase(mongoClientURI.getDatabase());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return manager;
    }

    private MongoCollection<Document> getDBCollection(String docName) {
        if (docName == null || docName.length() == 0) {
            return null;
        }
        return mongoDatabase.getCollection(docName);
    }

    private Document t2Doc(Object t) {
        if (t == null) {
            return null;
        }
        Document doc = Document.parse((String)FastJson.toJSONString(t));
        if (doc.get((Object)OBJECT_ID_KEY) != null) {
            doc.put(OBJECT_ID_KEY, (Object)new ObjectId((String)doc.get((Object)OBJECT_ID_KEY)));
        }
        return doc;
    }

    private <T> T doc2T(Document doc, Class<T> clazz) {
        if (doc == null) {
            return null;
        }
        Object objectId = doc.get((Object)OBJECT_ID_KEY);
        if (objectId != null && objectId instanceof ObjectId) {
            doc.put(OBJECT_ID_KEY, (Object)((ObjectId)objectId).toHexString());
        }
        return FastJson.toObject(FastJson.toJSONString(doc), clazz);
    }

    @Override
    public long count(String docName, Document docFilter) {
        MongoCollection<Document> collection = this.getDBCollection(docName);
        if (docFilter == null) {
            return collection.count();
        }
        return collection.count((Bson)docFilter);
    }

    @Override
    public String insertOne(String docName, Document doc) {
        if (doc == null) {
            return null;
        }
        MongoCollection<Document> collection = this.getDBCollection(docName);
        try {
            collection.insertOne((Object)doc);
            return doc.getObjectId((Object)OBJECT_ID_KEY).toHexString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean insertMany(String docName, List<Document> docs) {
        if (docs == null || docs.size() == 0) {
            return false;
        }
        MongoCollection<Document> collection = this.getDBCollection(docName);
        try {
            collection.insertMany(docs);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public String insertOne(String docName, Object t) {
        if (t == null) {
            return null;
        }
        MongoCollection<Document> collection = this.getDBCollection(docName);
        try {
            Document doc = this.t2Doc(t);
            collection.insertOne((Object)doc);
            return doc.getObjectId((Object)OBJECT_ID_KEY).toHexString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean insertMany(List<Object> ts, String docName) {
        if (ts == null || ts.size() == 0) {
            return false;
        }
        MongoCollection<Document> collection = this.getDBCollection(docName);
        try {
            ArrayList<Document> docs = new ArrayList<Document>();
            for (Object t : ts) {
                docs.add(this.t2Doc(t));
            }
            collection.insertMany(docs);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public Document findByObjectId(String docName, String objectHexString) {
        if (objectHexString == null) {
            return null;
        }
        ObjectId objectId = new ObjectId(objectHexString);
        Document doc = new Document();
        doc.put(OBJECT_ID_KEY, (Object)objectId);
        MongoCursor<Document> cursor = this.baseFind(docName, doc);
        doc = null;
        if (cursor.hasNext()) {
            doc = (Document)cursor.next();
        }
        return doc;
    }

    @Override
    public <T> T findByObjectId(String docName, String objectHexString, Class<T> clazz) {
        Document doc = this.findByObjectId(docName, objectHexString);
        return this.doc2T(doc, clazz);
    }

    private MongoCursor<Document> baseFind(String docName, Document docFilter) {
        MongoCollection<Document> collection = this.getDBCollection(docName);
        FindIterable result = docFilter == null ? collection.find() : collection.find((Bson)docFilter);
        MongoCursor cursor = null;
        if (result != null) {
            cursor = result.iterator();
        }
        return cursor;
    }

    @Override
    public List<Document> findMany(String docName, Document docFilter) {
        ArrayList<Document> docs = new ArrayList<Document>();
        MongoCursor<Document> cursor = this.baseFind(docName, docFilter);
        while (cursor.hasNext()) {
            docs.add((Document)cursor.next());
        }
        cursor.close();
        return docs;
    }

    @Override
    public List<Document> findMany(String docName, Object tFilter) {
        if (tFilter == null) {
            return this.findMany(docName, null);
        }
        return this.findMany(docName, this.t2Doc(tFilter));
    }

    @Override
    public <T> List<T> findMany(String docName, Document docFilter, Class<T> clazz) {
        List<Document> docs = this.findMany(docName, docFilter);
        ArrayList<T> objs = new ArrayList<T>();
        for (Document doc : docs) {
            objs.add(this.doc2T(doc, clazz));
        }
        return objs;
    }

    @Override
    public <T> List<T> findMany(String docName, Object tFilter, Class<T> clazz) {
        List<Document> docs = this.findMany(docName, tFilter);
        ArrayList<T> objs = new ArrayList<T>();
        for (Document doc : docs) {
            objs.add(this.doc2T(doc, clazz));
        }
        return objs;
    }

    private UpdateResult baseUpdateOne(String docName, Document doc, Document docFilter) {
        if (doc == null || doc.size() == 0) {
            return null;
        }
        if (docFilter == null) {
            docFilter = new Document();
        }
        MongoCollection<Document> collection = this.getDBCollection(docName);
        return collection.updateOne((Bson)docFilter, (Bson)new Document(OPERATOR_SET, (Object)doc));
    }

    private DeleteResult baseDeleteOne(String docName, Document doc) {
        if (doc == null || doc.size() == 0) {
            return null;
        }
        MongoCollection<Document> collection = this.getDBCollection(docName);
        return collection.deleteOne((Bson)doc);
    }

    private DeleteResult baseDeleteMany(String docName, Document doc) {
        MongoCollection<Document> collection = this.getDBCollection(docName);
        return collection.deleteMany((Bson)doc);
    }

    private UpdateResult baseUpdateMany(String docName, Document doc, Document docFilter) {
        if (doc == null || doc.size() == 0) {
            return null;
        }
        if (docFilter == null) {
            docFilter = new Document();
        }
        MongoCollection<Document> collection = this.getDBCollection(docName);
        return collection.updateMany((Bson)docFilter, (Bson)new Document(OPERATOR_SET, (Object)doc));
    }

    @Override
    public boolean updateOne(String docName, Document doc, Document docFilter) {
        UpdateResult upResult = this.baseUpdateOne(docName, doc, docFilter);
        if (upResult == null) {
            return false;
        }
        long matched = upResult.getMatchedCount();
        long modified = upResult.getModifiedCount();
        return matched == 1L && modified == 1L;
    }

    @Override
    public boolean updateOneByObjectId(String docName, Document doc, String objectHexString) {
        if (objectHexString == null) {
            return false;
        }
        Document docFilter = new Document(OBJECT_ID_KEY, (Object)new ObjectId(objectHexString));
        return this.updateOne(docName, doc, docFilter);
    }

    @Override
    public boolean updateOneByObjectId(String docName, Object t, String objectHexString) {
        if (objectHexString == null) {
            return false;
        }
        return this.updateOneByObjectId(docName, this.t2Doc(t), objectHexString);
    }

    @Override
    public boolean updateMany(String docName, Document doc, Document docFilter) {
        UpdateResult upResult = this.baseUpdateMany(docName, doc, docFilter);
        if (upResult == null) {
            return false;
        }
        long matched = upResult.getMatchedCount();
        long modified = upResult.getModifiedCount();
        return matched > 0L && modified > 0L;
    }

    @Override
    public boolean updateOne(String docName, Object t, Object tFilter) {
        return this.updateOne(docName, this.t2Doc(t), this.t2Doc(tFilter));
    }

    @Override
    public boolean updateMany(String docName, Object t, Object tFilter) {
        return this.updateMany(docName, this.t2Doc(t), this.t2Doc(tFilter));
    }

    @Override
    public <T> void findByPage(String docName, PageEntity<T> pageEntity) {
        if (docName == null || pageEntity == null) {
            return;
        }
        MongoCollection<Document> collection = this.getDBCollection(docName);
        pageEntity.setTotalCount(this.count(docName, this.t2Doc(pageEntity.getQueryCondition())));
        FindIterable findIterable = collection.find((Bson)this.t2Doc(pageEntity.getQueryCondition())).skip(pageEntity.getPageSize() * (pageEntity.getPageNumber() - 1)).limit(pageEntity.getPageSize());
        if (pageEntity.getSorts().size() > 0) {
            List<Sort> sorts = pageEntity.getSorts();
            Document sortCondition = new Document();
            for (Sort sort : sorts) {
                sortCondition.put(sort.getColumn(), (Object)sort.getSortType().code);
            }
            findIterable.sort((Bson)sortCondition);
        }
        ArrayList<Object> docs = new ArrayList<Object>();
        MongoCursor cursor = findIterable.iterator();
        while (cursor.hasNext()) {
            docs.add(cursor.next());
        }
        cursor.close();
        ArrayList objs = new ArrayList();
        for (Document document : docs) {
            objs.add(this.doc2T(document, pageEntity.getTClass()));
        }
        pageEntity.setList(objs);
    }

    @Override
    public boolean deleteOneByObjectId(String docName, String objectHexString) {
        DeleteResult deleteResult = this.baseDeleteOne(docName, new Document(OBJECT_ID_KEY, (Object)new ObjectId(objectHexString)));
        return deleteResult.getDeletedCount() > 0L;
    }

    @Override
    public boolean deleteOneByCondition(String docName, Document filter) {
        DeleteResult deleteResult = this.baseDeleteOne(docName, filter);
        return deleteResult.getDeletedCount() > 0L;
    }

    @Override
    public boolean deleteOneByCondition(String docName, Object tFilter) {
        return this.deleteOneByCondition(docName, this.t2Doc(tFilter));
    }

    @Override
    public boolean deleteManyByCondition(String docName, Document filter) {
        DeleteResult deleteResult = this.baseDeleteMany(docName, filter);
        return deleteResult.getDeletedCount() > 0L;
    }

    @Override
    public boolean deleteManyByCondition(String docName, Object tFilter) {
        return this.deleteOneByCondition(docName, this.t2Doc(tFilter));
    }

    @Override
    public Document findOne(String docName, Document docFilter) {
        MongoCursor<Document> cursor = this.baseFind(docName, docFilter);
        Document doc = null;
        if (cursor.hasNext()) {
            doc = (Document)cursor.next();
        }
        cursor.close();
        return doc;
    }

    @Override
    public <T> T findOne(String docName, Object tFilter, Class<T> clazz) {
        Document doc = this.findOne(docName, this.t2Doc(tFilter));
        return this.doc2T(doc, clazz);
    }

    @Override
    public Document findOne(String docName, Object t) {
        return this.findOne(docName, this.t2Doc(t));
    }

    @Override
    public <T> T findOne(String docName, Document docFilter, Class<T> clazz) {
        Document doc = this.findOne(docName, docFilter);
        return this.doc2T(doc, clazz);
    }
}

