/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit3d.core.db;

import com.thankjava.toolkit.core.reflect.ReflectUtil;
import com.thankjava.toolkit3d.core.db.mongodb.MongoManager;
import com.thankjava.toolkit3d.core.db.mysql.MyBatisManager;
import com.thankjava.toolkit3d.core.db.redis.RedisManager;
import java.lang.reflect.Method;

public final class BasicDBManagerBuilder {
    private BasicDBManagerBuilder() {
    }

    public static RedisManager buildRedisManager(String ... configPath) {
        return (RedisManager)BasicDBManagerBuilder.doBuild("com.thankjava.toolkit3d.core.db.redis.impl.RedisManagerImpl", configPath);
    }

    public static MongoManager buildMongoManager(String ... configPath) {
        return (MongoManager)BasicDBManagerBuilder.doBuild("com.thankjava.toolkit3d.core.db.mongodb.impl.MongoManagerImpl", configPath);
    }

    public static MyBatisManager buildMyBatisManager() {
        return (MyBatisManager)BasicDBManagerBuilder.doBuild("com.thankjava.toolkit3d.core.db.mysql.impl.MyBatisManagerImpl", null);
    }

    private static Object doBuild(String classPath, String ... configPath) {
        try {
            Method method = ReflectUtil.getMethod(Class.forName(classPath), (String)"init", (Class[])new Class[]{String.class});
            if (configPath != null && configPath.length > 0) {
                return ReflectUtil.invokeMethod(null, (Method)method, (Object[])new Object[]{configPath[0]});
            }
            Object str = null;
            return ReflectUtil.invokeMethod(null, (Method)method, (Object[])new Object[]{str});
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

