/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit3d.bean.http;

import com.thankjava.toolkit3d.bean.http.Charset;
import com.thankjava.toolkit3d.bean.http.RequestContentType;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class Parameters {
    private String contentType = null;
    private List<NameValuePair> nameValuePairs = null;
    private String text = null;
    private byte[] byteData = null;
    private String contentEncoding = null;
    private File file = null;

    public Parameters(String name, String value) {
        this.nameValuePairs = new ArrayList<NameValuePair>();
        this.nameValuePairs.add((NameValuePair)new BasicNameValuePair(name, value));
        this.contentType = RequestContentType.APPLICATION_FORM_URLENCODED.code;
    }

    public Parameters(Map<String, String> parameters) {
        if (parameters == null || parameters.size() == 0) {
            return;
        }
        this.nameValuePairs = new ArrayList<NameValuePair>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            this.nameValuePairs.add((NameValuePair)new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        this.contentType = RequestContentType.APPLICATION_FORM_URLENCODED.code;
    }

    public Parameters append(String key, String value) {
        if (this.nameValuePairs == null) {
            this.nameValuePairs = new ArrayList<NameValuePair>();
        }
        this.nameValuePairs.add((NameValuePair)new BasicNameValuePair(key, value));
        return this;
    }

    public Parameters(String text) {
        this.text = text;
        this.contentType = RequestContentType.TEXT_PLAIN.code;
    }

    public Parameters(String text, RequestContentType contentType, Charset ... contentEncoding) {
        this.text = text;
        this.contentType = contentType.code;
        if (contentEncoding != null && contentEncoding.length > 0) {
            this.contentEncoding = contentEncoding[0].charset;
        }
    }

    public Parameters(String text, String contentType, Charset ... contentEncoding) {
        this.text = text;
        this.contentType = contentType;
        if (contentEncoding != null && contentEncoding.length > 0) {
            this.contentEncoding = contentEncoding[0].charset;
        }
    }

    public Parameters(byte[] byteData, Charset ... contentEncoding) {
        this.byteData = byteData;
        this.contentType = RequestContentType.APPLICATION_OCTET_STREAM.code;
        if (contentEncoding != null && contentEncoding.length > 0) {
            this.contentEncoding = contentEncoding[0].charset;
        }
    }

    public Parameters(byte[] byteData, RequestContentType contentType, Charset ... contentEncoding) {
        this.byteData = byteData;
        this.contentType = contentType.code;
        if (contentEncoding != null && contentEncoding.length > 0) {
            this.contentEncoding = contentEncoding[0].charset;
        }
    }

    public Parameters(byte[] byteData, String contentType, Charset ... contentEncoding) {
        this.byteData = byteData;
        this.contentType = contentType;
        if (contentEncoding != null && contentEncoding.length > 0) {
            this.contentEncoding = contentEncoding[0].charset;
        }
    }

    public Parameters(File file, RequestContentType contentType, Charset ... contentEncoding) {
        this.file = file;
        this.contentType = contentType.code;
        if (contentEncoding != null && contentEncoding.length > 0) {
            this.contentEncoding = contentEncoding[0].charset;
        }
    }

    public Parameters(File file, String contentType, Charset ... contentEncoding) {
        this.file = file;
        this.contentType = contentType;
        if (contentEncoding != null && contentEncoding.length > 0) {
            this.contentEncoding = contentEncoding[0].charset;
        }
    }

    public List<NameValuePair> getNameValuePair() {
        return this.nameValuePairs;
    }

    public String getText() {
        return this.text;
    }

    public String getContentType() {
        return this.contentType;
    }

    public byte[] getByteData() {
        return this.byteData;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public File getFile() {
        return this.file;
    }
}

