/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit3d.bean.http;

import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public class Headers {
    private Map<String, Header> headers = null;

    public Headers(String name, String value) {
        this.headers = new HashMap<String, Header>();
        this.headers.put(name, (Header)new BasicHeader(name, value));
    }

    public Headers(Map<String, String> headers) {
        if (headers == null || headers.size() == 0) {
            return;
        }
        this.headers = new HashMap<String, Header>();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.headers.put(entry.getKey(), (Header)new BasicHeader(entry.getKey(), entry.getValue()));
        }
    }

    public Headers(Header[] headers) {
        if (headers == null || headers.length == 0) {
            return;
        }
        this.headers = new HashMap<String, Header>();
        for (Header header : headers) {
            this.headers.put(header.getName(), header);
        }
    }

    public void append(String name, String value) {
        this.headers.put(name, (Header)new BasicHeader(name, value));
    }

    public String getHeaderValue(String name) {
        Header header = this.headers.get(name);
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    public Header[] toHeaderArray() {
        Header[] headerArray = new Header[this.headers.size()];
        int index = 0;
        for (Map.Entry<String, Header> entry : this.headers.entrySet()) {
            headerArray[index] = entry.getValue();
            ++index;
        }
        return headerArray;
    }

    public String toString() {
        return this.headers.toString();
    }
}

