/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit3d.bean.http;

import com.thankjava.toolkit3d.bean.http.Charset;
import com.thankjava.toolkit3d.bean.http.Cookies;
import com.thankjava.toolkit3d.bean.http.Headers;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;

public class AsyncResponse {
    private Throwable exception = null;
    private int httpCode = -1;
    private Headers header;
    private Cookies cookies;
    private String dataString;
    private boolean setDataString = false;
    private byte[] dataByteArray;
    private boolean setDataByteArray = false;
    private HttpEntity httpEntity;
    private Charset charset;

    public AsyncResponse() {
    }

    public AsyncResponse(Throwable e) {
        this.exception = e;
    }

    public Headers getHeader() {
        return this.header;
    }

    public void setHeader(Headers header) {
        this.header = header;
    }

    public Cookies getCookies() {
        return this.cookies;
    }

    public void setCookies(Cookies cookies) {
        this.cookies = cookies;
    }

    public int getHttpCode() {
        return this.httpCode;
    }

    public void setHttpCode(int httpCode) {
        this.httpCode = httpCode;
    }

    public void setHttpEntity(HttpEntity httpEntity) {
        this.httpEntity = httpEntity;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public String getDataString() {
        if (this.exception == null) {
            try {
                if (!this.setDataString) {
                    this.dataString = EntityUtils.toString((HttpEntity)this.httpEntity, (String)this.charset.charset);
                    this.setDataString = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.dataString;
    }

    public byte[] getDataByteArray() {
        if (this.exception == null) {
            try {
                if (!this.setDataByteArray) {
                    this.dataByteArray = EntityUtils.toByteArray((HttpEntity)this.httpEntity);
                    this.setDataByteArray = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            return this.dataByteArray;
        }
        return null;
    }

    public boolean isEmptyDataString() {
        if (this.exception != null) {
            return true;
        }
        return this.getDataString() == null || this.dataString.length() == 0;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String toString() {
        if (this.exception != null) {
            return "request exception: \n\t" + this.exception.toString();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("httpCode: [");
        buffer.append(String.valueOf(this.httpCode));
        buffer.append("] header: [");
        buffer.append(this.header == null ? "" : this.header.toString());
        buffer.append("] cookies: [");
        buffer.append(this.cookies == null ? "" : this.cookies.toString());
        buffer.append("] dataString: [");
        buffer.append(this.getDataString() == null ? "" : this.getDataString());
        buffer.append("]");
        return buffer.toString();
    }
}

