/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit3d.bean.encrypit;

public class RSAKeyString {
    private String publicKey;
    private String privateKey;
    private String privatePem;
    private String publicPem;

    public RSAKeyString(String publicKey, String privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getPrivatePem() {
        if (this.privatePem == null) {
            this.privatePem = this.splitKey(this.privateKey, "-----BEGIN PRIVATE KEY-----", "-----END PRIVATE KEY-----");
        }
        return this.privatePem;
    }

    public String getPublicPem() {
        if (this.publicPem == null) {
            this.publicPem = this.splitKey(this.publicKey, "-----BEGIN PUBLIC KEY-----", "-----END PUBLIC KEY-----");
        }
        return this.publicPem;
    }

    private String splitKey(String keyStr, String beginStr, String endStr) {
        String separator = System.getProperty("line.separator");
        int len = keyStr.length();
        int freq = len / 64;
        StringBuilder sb = new StringBuilder(beginStr);
        for (int i = 0; i < freq; ++i) {
            sb.append(separator);
            sb.append(keyStr.substring(i * 64, (i + 1) * 64));
        }
        if (len > freq * 64) {
            sb.append(separator);
            sb.append(keyStr.substring(freq * 64));
        }
        sb.append(separator);
        sb.append(endStr);
        return sb.toString();
    }
}

