/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit3d.bean.db;

import com.thankjava.toolkit3d.bean.db.Sort;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PageEntity<T>
implements Serializable {
    private int pageSize = 20;
    private int pageNumber = 1;
    private long totalCount = 0L;
    private long pageCount = 0L;
    private Boolean hasNext = false;
    private Object queryCondition;
    private Class<T> tClass;
    private List<Sort> sorts = new ArrayList<Sort>();
    private List<T> list = new ArrayList<T>();

    private PageEntity() {
    }

    public static PageEntity newPageEntity(Class<?> tClass, Object queryCondition) {
        PageEntity pageEntity = new PageEntity();
        pageEntity.queryCondition = queryCondition;
        pageEntity.tClass = tClass;
        return pageEntity;
    }

    public PageEntity setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public PageEntity setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    public PageEntity setTotalCount(long totalCount) {
        this.totalCount = totalCount;
        this.pageCount = totalCount % (long)this.pageSize == 0L ? totalCount / (long)this.pageSize : totalCount / (long)this.pageSize + 1L;
        this.hasNext = this.totalCount > (long)(this.pageSize * this.pageNumber);
        return this;
    }

    public PageEntity addSort(Sort sort) {
        this.sorts.add(sort);
        return this;
    }

    public PageEntity setList(ArrayList<T> list) {
        this.list = list;
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public Object getQueryCondition() {
        return this.queryCondition;
    }

    public List<T> getList() {
        return this.list;
    }

    public Boolean getHasNext() {
        return this.hasNext;
    }

    public List<Sort> getSorts() {
        return this.sorts;
    }

    public Class<T> getTClass() {
        return this.tClass;
    }

    public long getPageCount() {
        return this.pageCount;
    }
}

