/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit.core.utils;

import com.thankjava.toolkit.bean.utils.TimeType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class TimeUtil {
    private static final Map<TimeType, SimpleDateFormat> simpleDateFormatMap = new HashMap<TimeType, SimpleDateFormat>();

    private TimeUtil() {
    }

    public static Date parseDate(TimeType timeType, String date) {
        SimpleDateFormat sdf = TimeUtil.getDateFormat(timeType);
        try {
            return sdf.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SimpleDateFormat getDateFormat(TimeType timeType) {
        SimpleDateFormat sdf;
        if (timeType == null) {
            timeType = TimeType.DEFAULT;
        }
        if ((sdf = simpleDateFormatMap.get((Object)timeType)) == null) {
            sdf = new SimpleDateFormat(timeType.getType());
            simpleDateFormatMap.put(timeType, sdf);
        }
        return sdf;
    }

    public static String formatDate(TimeType timeType, Date date) {
        return TimeUtil.getDateFormat(timeType).format(date);
    }

    public static Date offsetDate(Date date, int calendarUnit, int dateOffset) {
        if (date == null) {
            return null;
        }
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.add(calendarUnit, dateOffset);
        return ca.getTime();
    }
}

