/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit.core.thread;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class ThreadPool {
    private static final int INIT_THREAD_NUM = 50;
    private static final int MAX_THREAD_NUM = 10000;
    private static final int ALIVE_TIME = 60;
    private static final int WAIT_RUNNABLE_MAX_NUM = 200;
    protected static String DEFAULT_THREAD_GROUP_NAME = "ThreadPool-Group";
    protected static String DEFAULT_THREAD_NAME = "Thread";
    private static ThreadPoolExecutor threadPoolExecutor;

    public ThreadPool() {
        threadPoolExecutor = new ThreadPoolExecutor(50, 10000, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(200), new ThreadPoolExecutor.DiscardOldestPolicy());
    }

    public ThreadPool(int initThreadNum, int maxThreadNum, int aliveTime, int waitRunnableMaxNum) {
        threadPoolExecutor = new ThreadPoolExecutor(initThreadNum, maxThreadNum, (long)aliveTime, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(waitRunnableMaxNum), new ThreadPoolExecutor.DiscardOldestPolicy());
    }

    public ThreadPool allowCoreThreadTimeOut() {
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        return this;
    }

    public ThreadPool setThreadPoolName(String threadGroupName, String threadName) {
        DEFAULT_THREAD_GROUP_NAME = threadGroupName;
        DEFAULT_THREAD_NAME = threadName;
        threadPoolExecutor.setThreadFactory(new CustomThreadFactory());
        return this;
    }

    public void execute(Runnable command) {
        threadPoolExecutor.execute(command);
    }

    public void destroy() {
        if (!threadPoolExecutor.isShutdown()) {
            threadPoolExecutor.shutdown();
        }
    }

    class CustomThreadFactory
    implements ThreadFactory {
        private final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        CustomThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = DEFAULT_THREAD_GROUP_NAME + " " + this.poolNumber.getAndIncrement() + " ; " + DEFAULT_THREAD_NAME;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.group, runnable, this.namePrefix + " " + this.threadNumber.getAndIncrement(), 0L);
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }
}

