/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit.core.http;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Map;

public final class JDKHttp {
    private static final String CHARSET = "utf-8";

    private JDKHttp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, Map<String, String> ... head) {
        StringBuilder sb = new StringBuilder();
        BufferedReader in = null;
        try {
            String line;
            URL realUrl = new URL(url);
            URLConnection connection = realUrl.openConnection();
            if (head != null && head.length != 0) {
                Map<String, String> header = head[0];
                for (Map.Entry<String, String> h : header.entrySet()) {
                    connection.setRequestProperty(h.getKey(), h.getValue());
                }
            }
            connection.connect();
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, String bodyString, byte[] bodyByteArray, Map<String, String> ... head) {
        BufferedReader in = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            Closeable outputStream;
            URL realUrl = new URL(url);
            URLConnection connection = realUrl.openConnection();
            if (head != null && head.length != 0) {
                Map<String, String> header = head[0];
                for (Map.Entry<String, String> h : header.entrySet()) {
                    connection.setRequestProperty(h.getKey(), h.getValue());
                }
            }
            connection.setDoOutput(true);
            connection.setDoInput(true);
            if (bodyString != null) {
                outputStream = new OutputStreamWriter(connection.getOutputStream());
                ((Writer)outputStream).write(bodyString);
                ((OutputStreamWriter)outputStream).flush();
                ((OutputStreamWriter)outputStream).close();
            }
            if (bodyByteArray != null) {
                outputStream = connection.getOutputStream();
                ((OutputStream)outputStream).write(bodyByteArray);
                ((OutputStream)outputStream).flush();
                ((OutputStream)outputStream).close();
            }
            connection.connect();
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return sb.toString();
    }

    public static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

