/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit.core.bytecode;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ByteCodeClassLoader
extends ClassLoader {
    private final Map<String, Class<?>> byteCodesClass = new ConcurrentHashMap();
    private static final ByteCodeClassLoader instance = new ByteCodeClassLoader();
    private static final ClassLoader parentClassLoader = instance.getClass().getClassLoader();

    private ByteCodeClassLoader() {
    }

    public static ByteCodeClassLoader getLoader() {
        return instance;
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this.byteCodesClass.get(name);
        if (clazz == null) {
            return super.loadClass(name, false);
        }
        return clazz;
    }

    public Class<?> findClassFromParent(String name) throws ClassNotFoundException {
        return parentClassLoader.loadClass(name);
    }

    public void loadClassFromByteCodes(Map<String, byte[]> inputByteCodes) {
        if (inputByteCodes == null || inputByteCodes.isEmpty()) {
            throw new IllegalArgumentException("byteCodes can not be null");
        }
        for (Map.Entry<String, byte[]> byteCode : inputByteCodes.entrySet()) {
            this.byteCodesClass.put(byteCode.getKey(), this.defineClass(null, byteCode.getValue(), 0, byteCode.getValue().length));
        }
    }
}

