/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jtdgss;

import com.teradata.tdgss.jgssspi.GSSMechanism;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssLogger;
import com.teradata.tdgss.jtdgss.TdgssMinorStatus;
import java.util.Enumeration;
import java.util.Hashtable;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class TdgssName
implements GSSName {
    private final TdgssLogger logger;
    private byte[] name;
    private Oid nameType;
    private Hashtable nameImplementations;
    public static Oid GSS_C_NT_TDAT_MECHDATA;
    public static Oid GSS_TDAT_NT_USER_PASSWORD_ACCOUNT_DATA;
    public static Oid GSS_C_NT_TDAT_MECHDATA_UTF8;
    public static Oid GSS_C_NT_TDAT_MECHDATA_UTF16;
    public static Oid GSS_C_NT_TDAT_MECHDATA_UTF32;
    public static Oid GSS_C_NT_TDAT_USER;
    public static Oid GSS_C_NT_TDAT_PASSWORD;

    private static Oid newOid(String string) throws GSSException {
        return new Oid(string);
    }

    public TdgssName(byte[] byArray, Oid oid, GSSMechanism[] gSSMechanismArray, TdgssLogger tdgssLogger) {
        this.logger = tdgssLogger;
        this.name = byArray;
        this.nameType = oid;
        this.nameImplementations = new Hashtable(gSSMechanismArray.length);
        for (int i = 0; i < gSSMechanismArray.length; ++i) {
            GSSMechanism gSSMechanism = gSSMechanismArray[i];
            try {
                GSSName gSSName = gSSMechanism.createName(byArray, oid);
                if (gSSName == null) continue;
                this.nameImplementations.put(gSSMechanism, gSSName);
                continue;
            }
            catch (GSSException gSSException) {
                tdgssLogger.error(gSSException.getMessage());
            }
        }
    }

    public boolean equals(GSSName gSSName) {
        if (gSSName instanceof TdgssName) {
            TdgssName tdgssName = (TdgssName)gSSName;
            return tdgssName.toString().equals(this.toString());
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof GSSName) {
            GSSName gSSName = (GSSName)object;
            return this.equals(gSSName);
        }
        return false;
    }

    public int hasCode() {
        return this.name.hashCode();
    }

    public GSSName canonicalize(Oid oid) throws GSSException {
        Enumeration enumeration = this.nameImplementations.keys();
        while (enumeration.hasMoreElements()) {
            GSSMechanism gSSMechanism = (GSSMechanism)enumeration.nextElement();
            if (!gSSMechanism.getMech().equals(oid)) continue;
            GSSMechanism[] gSSMechanismArray = new GSSMechanism[]{gSSMechanism};
            return new TdgssName(this.name, this.nameType, gSSMechanismArray, this.logger);
        }
        throw new TdgssException(2);
    }

    public byte[] export() throws GSSException {
        throw new TdgssException(16, TdgssMinorStatus.TDGSS_ERR_FTN_NOT_AVAIL);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.nameImplementations.elements();
        while (enumeration.hasMoreElements()) {
            GSSName gSSName = (GSSName)enumeration.nextElement();
            stringBuffer.append(((Object)gSSName).toString());
        }
        return stringBuffer.toString();
    }

    public Oid getStringNameType() throws GSSException {
        throw new TdgssException(16, TdgssMinorStatus.TDGSS_ERR_FTN_NOT_AVAIL);
    }

    public boolean isAnonymous() {
        return false;
    }

    public boolean isMN() {
        return false;
    }

    protected GSSName getNameImplementation(GSSMechanism gSSMechanism) {
        return (GSSName)this.nameImplementations.get(gSSMechanism);
    }

    static {
        try {
            GSS_C_NT_TDAT_MECHDATA = TdgssName.newOid("1.3.6.1.4.1.191.1.1012.1.2.2");
            GSS_TDAT_NT_USER_PASSWORD_ACCOUNT_DATA = TdgssName.newOid("1.3.6.1.4.1.191.1.1012.1.2.1");
            GSS_C_NT_TDAT_MECHDATA_UTF8 = TdgssName.newOid("1.3.6.1.4.1.191.1.1012.1.2.3");
            GSS_C_NT_TDAT_MECHDATA_UTF16 = TdgssName.newOid("1.3.6.1.4.1.191.1.1012.1.2.4");
            GSS_C_NT_TDAT_MECHDATA_UTF32 = new Oid("1.3.6.1.4.1.191.1.1012.1.2.5");
            GSS_C_NT_TDAT_USER = new Oid("1.3.6.1.4.1.191.1.1012.1.2.6");
            GSS_C_NT_TDAT_PASSWORD = new Oid("1.3.6.1.4.1.191.1.1012.1.2.7");
        }
        catch (GSSException gSSException) {
            throw new ExceptionInInitializerError(gSSException);
        }
    }
}

