/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2jwt;

import com.teradata.tdgss.jgssp2jwt.JwtMechanism;
import com.teradata.tdgss.jgssp2jwt.JwtMinorStatus;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssLogger;
import com.teradata.tdgss.jtdgss.TdgssName;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class JwtName
implements GSSName {
    private final TdgssLogger logger;
    private byte[] name;
    private Oid namespace;

    public JwtName(byte[] byArray, Oid oid, TdgssLogger tdgssLogger) throws GSSException {
        this.logger = tdgssLogger;
        if (oid == null) {
            throw new TdgssException(3, JwtMinorStatus.JWT_ERR_INVALID_ARGUMENT);
        }
        this.namespace = oid;
        if (byArray == null) {
            throw new TdgssException(3, JwtMinorStatus.JWT_ERR_INVALID_ARGUMENT);
        }
        this.name = byArray;
    }

    public boolean equals(GSSName gSSName) throws GSSException {
        return this.getStringNameType().equals(gSSName.getStringNameType()) && this.toString().equals(((Object)gSSName).toString());
    }

    public boolean equals(Object object) {
        if (object != null) {
            try {
                GSSName gSSName = (GSSName)object;
                return this.equals(gSSName);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            catch (GSSException gSSException) {
                return false;
            }
        }
        return false;
    }

    public GSSName canonicalize(Oid oid) throws GSSException {
        if (oid == null || !oid.equals(JwtMechanism.mechOid)) {
            throw new TdgssException(2, JwtMinorStatus.JWT_ERR_INVALID_ARGUMENT);
        }
        return this;
    }

    public byte[] export() throws GSSException {
        throw new TdgssException(16, JwtMinorStatus.JWT_ERR_API_NOT_IMPLEMENTED);
    }

    public String toString() {
        try {
            if (this.namespace.equals(TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF16)) {
                return new String(this.name, "UTF-16");
            }
            if (this.namespace.equals(TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF8)) {
                return new String(this.name, "UTF-8");
            }
            if (this.namespace.equals(TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF32)) {
                return new String(this.name, "UTF-32");
            }
            return new String(this.name, "US-ASCII");
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException.getMessage());
            return null;
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage());
            return null;
        }
    }

    public Oid getStringNameType() throws GSSException {
        return this.namespace;
    }

    public boolean isAnonymous() {
        return false;
    }

    public boolean isMN() {
        return true;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + JwtName.hashCode(this.name);
        n = 31 * n + (this.namespace == null ? 0 : this.namespace.hashCode());
        return n;
    }

    private static int hashCode(byte[] byArray) {
        int n = 31;
        if (byArray == null) {
            return 0;
        }
        int n2 = 1;
        for (int i = 0; i < byArray.length; ++i) {
            n2 = n * n2 + byArray[i];
        }
        return n2;
    }

    public byte[] getName() {
        return this.name;
    }

    public void setName(byte[] byArray) {
        this.name = byArray;
    }
}

