/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.ifsupport.Result;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.EndStatementParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.StatementErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.StatementStatusParcel;
import com.teradata.jdbc.jdbc_4.statemachine.ActivityAnalyzer;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveContinueSubState;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveSuccessSubState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementContinueState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;
import java.sql.Statement;

public class ReceiveEndSubState
implements TDParcelState {
    private StatementReceiveState compositeState;
    protected Log log;

    public ReceiveEndSubState(StatementReceiveState statementReceiveState, EndStatementParcel endStatementParcel) {
        this.compositeState = statementReceiveState;
        this.log = this.compositeState.getController().getSession().getLog();
    }

    public TDParcelState action() throws SQLException {
        TDParcelState tDParcelState = null;
        Parcel parcel = this.compositeState.getNextParcel();
        if (!this.compositeState.preparingRequest()) {
            this.setResult(parcel);
        }
        if (parcel != null) {
            switch (parcel.getFlavor()) {
                case 12: {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("ReceiveEndSubState.action got PCLENDREQUEST, preparingRequest=" + this.compositeState.preparingRequest() + " this=" + this);
                    }
                    this.compositeState.getController().getStatement().getResults().markRequestAsComplete();
                    this.compositeState.setReturnState(null);
                    break;
                }
                case 8: 
                case 205: {
                    StatementStatusParcel statementStatusParcel = (StatementStatusParcel)parcel;
                    statementStatusParcel.verifySuccess();
                    tDParcelState = new ReceiveSuccessSubState(this.compositeState, statementStatusParcel);
                    break;
                }
                case 192: {
                    StatementErrorParcel statementErrorParcel = (StatementErrorParcel)parcel;
                    this.log.debug("Statement Error Parcel received: " + statementErrorParcel.getMsg());
                    this.compositeState.setActivityCount(true, 0L);
                    SQLException sQLException = ErrorFactory.makeDatabaseSQLException(statementErrorParcel.getMsg(), statementErrorParcel.getCode() * -1);
                    this.compositeState.getController().addBatchException(sQLException);
                    EndStatementParcel endStatementParcel = (EndStatementParcel)this.compositeState.scanForEndParcel(true);
                    if (endStatementParcel != null) {
                        tDParcelState = new ReceiveEndSubState(this.compositeState, endStatementParcel);
                        break;
                    }
                    tDParcelState = new ReceiveContinueSubState(this.compositeState, this);
                    break;
                }
                default: {
                    this.log.error("Unexpected parcel: " + parcel.getFlavor());
                    throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(parcel.getFlavor()));
                }
            }
        } else if (this.compositeState.preparingRequest() || this.compositeState.getController().getResultTypeExpected() == 5) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("ReceiveEndSubState.action reached end-of-packet, reading continuously, this=" + this);
            }
            tDParcelState = new ReceiveContinueSubState(this.compositeState, null);
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("ReceiveEndSubState.action reached end-of-packet, pausing fetch, this=" + this);
            }
            this.compositeState.getController().setHistoricalState(new StatementContinueState(this.compositeState.getController(), this.compositeState));
            this.compositeState.setHistoricalState(null);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("ReceiveEndSubState.action returning returnSubState=" + tDParcelState);
        }
        return tDParcelState;
    }

    private void setResult(Parcel parcel) throws SQLException {
        Result result = null;
        boolean bl = false;
        short s = this.compositeState.getActivityType();
        switch (this.compositeState.getController().getResultTypeExpected()) {
            case 2: {
                if (ActivityAnalyzer.resultSetExpected(s)) {
                    if (this.compositeState.getCurrentResultSet().isMoreToFetch()) break;
                    result = new Result(this.compositeState.getCurrentResultSet());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("ReceiveEndSubState.setResult case 1 adding result=" + result + ", this=" + this);
                    }
                    this.compositeState.addResult(result);
                    break;
                }
                TeraResultSetMetaData teraResultSetMetaData = this.compositeState.getController().getSession().constructResultSetMetaData();
                TDResultSet tDResultSet = this.compositeState.getController().getSession().constructResultSet(teraResultSetMetaData, s, (Statement)((Object)this.compositeState.getController().getStatement()), this.compositeState.getController(), this.log);
                tDResultSet.setMoreToFetch(false);
                result = new Result(tDResultSet);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("ReceiveEndSubState.setResult case 2 adding result=" + result + ", this=" + this);
                }
                this.compositeState.addResult(result);
                break;
            }
            case 5: {
                if (!ActivityAnalyzer.resultSetExpected(s)) {
                    if (this.compositeState.getController().getStatement().hasGeneratedKeysRequest()) {
                        if (parcel == null || parcel.getFlavor() != 12) {
                            bl = true;
                            result = new Result(this.compositeState.getStatusExecuteFailed(), this.compositeState.getActivityCount());
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("ReceiveEndSubState.setResult case 3 adding result=" + result + ", this=" + this);
                            }
                        } else {
                            result = new Result(this.compositeState.getActivityCount(), this.compositeState.getCurrentResultSet());
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("ReceiveEndSubState.setResult case 4 adding result=" + result + ", this=" + this);
                            }
                        }
                    } else {
                        result = new Result(this.compositeState.getStatusExecuteFailed(), this.compositeState.getActivityCount());
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("ReceiveEndSubState.setResult case 5 adding result=" + result + ", this=" + this);
                        }
                    }
                } else {
                    TeraResultSetMetaData teraResultSetMetaData = this.compositeState.getController().getSession().constructResultSetMetaData();
                    TDResultSet tDResultSet = this.compositeState.getController().getSession().constructResultSet(teraResultSetMetaData, s, (Statement)((Object)this.compositeState.getController().getStatement()), this.compositeState.getController(), this.log);
                    tDResultSet.setMoreToFetch(false);
                    result = new Result(tDResultSet);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("ReceiveEndSubState.setResult case 6 adding result=" + result + ", this=" + this);
                    }
                }
                this.compositeState.addResult(result);
                break;
            }
            case 1: 
            case 3: {
                if (this.compositeState.getCurrentResultSet() != null) {
                    if (ActivityAnalyzer.resultSetExpected(s)) {
                        if (this.compositeState.getCurrentResultSet().isMoreToFetch()) break;
                        result = this.compositeState.getController().getSession().getURLParameters().getConnectFunction() == 1 ? new Result(this.compositeState.getActivityCount(), this.compositeState.getCurrentResultSet()) : new Result(this.compositeState.getCurrentResultSet());
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("ReceiveEndSubState.setResult case 7 adding result=" + result + ", this=" + this);
                        }
                        this.compositeState.addResult(result);
                        break;
                    }
                    if (ActivityAnalyzer.update(this.compositeState.getActivityType()) && this.compositeState.getController().getStatement().hasGeneratedKeysRequest() && !this.compositeState.getCurrentResultSet().isMoreToFetch()) {
                        result = new Result(this.compositeState.getActivityCount(), this.compositeState.getCurrentResultSet());
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("ReceiveEndSubState.setResult case 8 adding result=" + result + ", this=" + this);
                        }
                        this.compositeState.addResult(result);
                        break;
                    }
                    if (ActivityAnalyzer.resultSetExpected(s) && !this.compositeState.getCurrentResultSet().isMoreToFetch()) {
                        result = new Result(this.compositeState.getCurrentResultSet());
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("ReceiveEndSubState.setResult case 9 adding result=" + result + ", this=" + this);
                        }
                        this.compositeState.addResult(result);
                        break;
                    }
                    if (ActivityAnalyzer.update(this.compositeState.getActivityType())) {
                        result = new Result(this.compositeState.getStatusExecuteFailed(), this.compositeState.getActivityCount());
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("ReceiveEndSubState.setResult case 10 adding result=" + result + ", this=" + this);
                        }
                        this.compositeState.addResult(result);
                        break;
                    }
                    result = new Result(false, 0L);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("ReceiveEndSubState.setResult case 11 adding result=" + result + ", this=" + this);
                    }
                    this.compositeState.addResult(result);
                    break;
                }
                result = new Result(this.compositeState.getStatusExecuteFailed(), this.compositeState.getActivityCount());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("ReceiveEndSubState.setResult case 12 adding result=" + result + ", this=" + this);
                }
                this.compositeState.addResult(result);
                break;
            }
        }
        if (this.compositeState.getCurrentResultSet() != null && !bl) {
            this.compositeState.getCurrentResultSet().lastRowFetched();
            this.compositeState.getCurrentResultSet().setMoreToFetch(false);
            this.compositeState.setCurrentResultSet(null);
        }
    }
}

