/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc_4.parcel.IndicRequestParcel;
import com.teradata.jdbc.jdbc_4.parcel.IndicRequestParcelAltHeader;
import com.teradata.jdbc.jdbc_4.parcel.MultiTSRParcel;
import com.teradata.jdbc.jdbc_4.parcel.MultiTSRParcelAltHeader;
import com.teradata.jdbc.jdbc_4.parcel.OptionsParcel;
import com.teradata.jdbc.jdbc_4.parcel.ResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.SPOptionsParcel;
import com.teradata.jdbc.jdbc_4.parcel.SPOptionsParcelAltHeader;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementSendState;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;

public class CreateProcedureStatementSendState
extends StatementSendState {
    private boolean firstPass = true;
    private boolean isLast = false;
    int MaxSegmentSize;
    int MaximumNumberOfSegments;
    short sequenceNumber = 1;
    private byte[] text;
    protected static final int MAX_APH_SEG_SIZE = 999500;
    protected int srcPosition = 0;

    public CreateProcedureStatementSendState(StatementController statementController) {
        super(statementController);
        this.MaxSegmentSize = statementController.getSession().getMaximumSegmentSize();
        this.MaximumNumberOfSegments = statementController.getSession().getMaximumNumberOfSegments();
    }

    public TDParcelState action() throws SQLException {
        if (this.firstPass) {
            this.text = Encoder.encodeRequestText(this.getController().getSession(), this.getController().getQuery());
            this.altHeaderRequired();
        }
        String string = this.getQuery();
        this.initPacket();
        this.initMultiTSR();
        if (this.firstPass) {
            this.initOptions(this.getController().getMode(), this.getController().getLobSelect());
        }
        this.initIndic(string);
        if (this.firstPass) {
            this.initSPOptions();
        }
        this.initRsp();
        if (!this.firstPass) {
            this.getController().getStatement().initResults();
        }
        this.sendPacket();
        return this.returnToController();
    }

    private String getQuery() throws SQLException {
        String string;
        if (this.isAltHeader()) {
            string = this.getController().getQuery();
            if (this.text.length - this.srcPosition <= 999500) {
                this.isLast = true;
            }
        } else {
            String string2 = this.getController().getQuery();
            int n = string2.length();
            if (this.MaxSegmentSize == 0) {
                throw ErrorFactory.makeDriverJDBCException("TJ307", this.getController().getSession().getTeradataDatabaseVersion());
            }
            if (n > this.MaxSegmentSize * this.MaximumNumberOfSegments) {
                throw ErrorFactory.makeDriverJDBCException("TJ308", n, this.MaxSegmentSize * this.MaximumNumberOfSegments);
            }
            if (n > this.MaxSegmentSize) {
                int n2 = this.MaxSegmentSize;
                string = string2.substring(0, n2);
                this.getController().setQuery(string2.substring(n2));
            } else {
                this.isLast = true;
                int n3 = n;
                string = string2;
            }
        }
        return string;
    }

    private void initMultiTSR() throws SQLException {
        MultiTSRParcel multiTSRParcel = this.isAltHeader() ? new MultiTSRParcelAltHeader(this.controller.getSession()) : new MultiTSRParcel(this.controller.getSession());
        short s = this.sequenceNumber;
        this.sequenceNumber = (short)(s + 1);
        multiTSRParcel.setSequenceNumber(s);
        multiTSRParcel.setIsLast(this.isLast);
        this.packet.addParcel(multiTSRParcel);
    }

    protected void initIndic(String string) throws SQLException {
        IndicRequestParcel indicRequestParcel = null;
        if (this.isAltHeader()) {
            indicRequestParcel = new IndicRequestParcelAltHeader(this.controller.getSession());
            if (this.isLast) {
                indicRequestParcel.setRequestText(this.text, this.srcPosition, this.text.length - this.srcPosition);
            } else {
                indicRequestParcel.setRequestText(this.text, this.srcPosition, 999500);
                this.srcPosition += 999500;
            }
        } else {
            indicRequestParcel = new IndicRequestParcel(this.controller.getSession());
            indicRequestParcel.setRequestText(string);
        }
        this.packet.addParcel(indicRequestParcel);
    }

    protected void initSPOptions() throws SQLException {
        SPOptionsParcel sPOptionsParcel = this.isAltHeader() ? new SPOptionsParcelAltHeader(this.controller.getSession()) : new SPOptionsParcel(this.controller.getSession());
        sPOptionsParcel.setSPLOption("NOSPL".equals(this.controller.getSession().getURLParameters().getSpl()) ? (byte)78 : 89);
        this.packet.addParcel(sPOptionsParcel);
        this.firstPass = false;
    }

    protected TDParcelState returnToController() {
        StatementReceiveState statementReceiveState = new StatementReceiveState(this.getController());
        this.controller.setHistoricalReturnState(this.isLast ? null : this);
        return statementReceiveState;
    }

    protected void altHeaderRequired() {
        this.bufferSize = 59 + OptionsParcel.standardOptionsParcelLength(this.controller.getSession()) + 4 + 6 + ResponseParcel.LENGTH + this.text.length;
        if (this.bufferSize > 65104 && this.controller.getSession().isAphSupported()) {
            this.altHeader = true;
            this.bufferSize += 20;
        }
        this.log.debug("USING ALTHEADER : " + this.altHeader);
        this.log.debug("Buffer size needed is: " + this.bufferSize);
    }
}

