/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.raw;

import com.teradata.jdbc.jdbc.raw.RawConnection;
import com.teradata.jdbc.jdbc.raw.RawPreparedStatement;
import com.teradata.jdbc.jdbc.raw.RawResultSetMetaData;
import com.teradata.jdbc.jdbc_4.io.BufferContainer;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public abstract class RawResultSet
implements BufferContainer {
    private RawPreparedStatement pstmt = null;
    private byte[] rawMessageReceived = new byte[52];
    private int rowNumber = 0;
    private int rowCount = 1;

    public RawResultSet(RawPreparedStatement rawPreparedStatement) throws SQLException {
        this.pstmt = rawPreparedStatement;
    }

    public byte[] getBuffer() {
        return this.rawMessageReceived;
    }

    public void setBuffer(byte[] byArray) {
        this.rawMessageReceived = byArray;
    }

    protected void abortIfClosed() throws SQLException {
        this.pstmt.abortIfClosed();
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ598");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveResults() throws SQLException {
        TDNetworkIOIF tDNetworkIOIF = ((RawConnection)((Object)this.pstmt.getConnection())).getIO();
        tDNetworkIOIF.acquireReadLock();
        try {
            tDNetworkIOIF.read(this, this.pstmt.getQueryTimeout() * 1000, null, true);
            Object var3_2 = null;
            tDNetworkIOIF.releaseReadLock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            tDNetworkIOIF.releaseReadLock();
            throw throwable;
        }
    }

    public boolean absolute(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ600");
    }

    public void afterLast() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ600");
    }

    public void beforeFirst() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ600");
    }

    public void cancelRowUpdates() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void clearWarnings() throws SQLException {
        this.abortIfClosed();
    }

    public void close() throws SQLException {
        this.rawMessageReceived = null;
    }

    public void deleteRow() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public int findColumn(String string) throws SQLException {
        this.abortIfClosed();
        if (string.equals("RawMessage")) {
            return 1;
        }
        throw ErrorFactory.makeDriverJDBCException("TJ602", string);
    }

    public boolean first() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ600");
    }

    public Array getArray(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Array getArray(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Blob getBlob(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Blob getBlob(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public boolean getBoolean(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public boolean getBoolean(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public byte getByte(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public byte getByte(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public byte[] getBytes(int n) throws SQLException {
        this.abortIfClosed();
        ((RawResultSetMetaData)((Object)this.pstmt.getMetaData())).abortIfIndexNotValid(n);
        return this.rawMessageReceived;
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Reader getCharacterStream(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Reader getCharacterStream(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Clob getClob(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Clob getClob(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public int getConcurrency() throws SQLException {
        this.abortIfClosed();
        return 1007;
    }

    public String getCursorName() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Date getDate(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Date getDate(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public double getDouble(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public double getDouble(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public int getFetchDirection() throws SQLException {
        this.abortIfClosed();
        return 1000;
    }

    public int getFetchSize() throws SQLException {
        this.abortIfClosed();
        return 0;
    }

    public float getFloat(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public float getFloat(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public int getInt(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public int getInt(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public long getLong(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public long getLong(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.abortIfClosed();
        return this.pstmt.getMetaData();
    }

    public Object getObject(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Object getObject(int n, Map map) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Object getObject(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Object getObject(String string, Map map) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Ref getRef(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Ref getRef(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public int getRow() throws SQLException {
        this.abortIfClosed();
        return this.rowNumber > this.rowCount ? 0 : this.rowNumber;
    }

    public short getShort(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public short getShort(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Statement getStatement() throws SQLException {
        this.abortIfClosed();
        return (Statement)((Object)this.pstmt);
    }

    public String getString(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public String getString(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Time getTime(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Time getTime(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public int getType() throws SQLException {
        this.abortIfClosed();
        return 1003;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public URL getURL(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public URL getURL(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public SQLWarning getWarnings() throws SQLException {
        this.abortIfClosed();
        return null;
    }

    public void insertRow() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public boolean isAfterLast() throws SQLException {
        this.abortIfClosed();
        return this.rowNumber > this.rowCount;
    }

    public boolean isBeforeFirst() throws SQLException {
        this.abortIfClosed();
        return this.rowNumber == 0;
    }

    public boolean isFirst() throws SQLException {
        this.abortIfClosed();
        return this.rowNumber == 1;
    }

    public boolean isLast() throws SQLException {
        this.abortIfClosed();
        return this.rowNumber == this.rowCount;
    }

    public boolean last() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ600");
    }

    public void moveToCurrentRow() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ601");
    }

    public void moveToInsertRow() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ601");
    }

    public boolean next() throws SQLException {
        this.abortIfClosed();
        int n = this.rowNumber = this.rowNumber <= this.rowCount ? this.rowNumber + 1 : this.rowNumber;
        if (this.rowNumber <= this.rowCount) {
            this.receiveResults();
            return true;
        }
        return false;
    }

    public boolean previous() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ600");
    }

    public void refreshRow() throws SQLException {
        this.abortIfClosed();
    }

    public boolean relative(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ600");
    }

    public boolean rowDeleted() throws SQLException {
        this.abortIfClosed();
        return false;
    }

    public boolean rowInserted() throws SQLException {
        this.abortIfClosed();
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        this.abortIfClosed();
        return false;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.abortIfClosed();
    }

    public void setFetchSize(int n) throws SQLException {
        this.abortIfClosed();
    }

    public void updateArray(int n, Array array) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateArray(String string, Array array) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateInt(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateLong(int n, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateLong(String string, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateNull(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateNull(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateRow() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateShort(int n, short s) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateShort(String string, short s) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateString(int n, String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateString(String string, String string2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    public boolean wasNull() throws SQLException {
        this.abortIfClosed();
        return false;
    }

    public int getHoldability() throws SQLException {
        this.abortIfClosed();
        return 1;
    }

    public Reader getNCharacterStream(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "getNCharacterStream(int)");
    }

    public Reader getNCharacterStream(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "getNCharacterStream(String)");
    }

    public String getNString(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "getNString(int)");
    }

    public String getNString(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "getNString(String)");
    }

    public boolean isClosed() {
        return this.rawMessageReceived == null;
    }

    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateAsciiStream(int,InputStream)");
    }

    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateAsciiStream(int,InputStream,long)");
    }

    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateAsciiStream(String,InputStream");
    }

    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ215", "updateAsciiStream(String,InputStream,long)");
    }

    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateBinaryStream(int,InputStream)");
    }

    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateBinaryStream(int,InputStream,long)");
    }

    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateBinaryStream(String,InputStream");
    }

    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateBinaryStream(String,InputStream,long)");
    }

    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateBlob(int,InputStream");
    }

    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateBlob(int,InputStream,long)");
    }

    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateBlob(String,InputStream");
    }

    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateBlob(String,InputStream,long)");
    }

    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateCharacterStream(int,Reader)");
    }

    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateCharacterStream(int,Reader,long)");
    }

    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateCharacterStream(String,Reader)");
    }

    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateCharacterStream(String,Reader,long)");
    }

    public void updateClob(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateClob(int,Reader");
    }

    public void updateClob(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateClob(int,Reader,long)");
    }

    public void updateClob(String string, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateClob(String,Reader)");
    }

    public void updateClob(String string, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateClob(String,Reader,long");
    }

    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateNCharacterStream(int,Reader)");
    }

    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateNCharacterStream(int,Reader,long)");
    }

    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateNCharacterStream(String,Reader)");
    }

    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateNCharacterStream(String,Reader,long)");
    }

    public void updateNClob(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateNClob(int,Reader)");
    }

    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateNClob(int,Reader,long)");
    }

    public void updateNClob(String string, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateNClob(String,Reader)");
    }

    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateNClob(String,Rader,long)");
    }

    public void updateNString(int n, String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateNString(int,String)");
    }

    public void updateNString(String string, String string2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "updateNString(String,String)");
    }
}

